USE $(varSOURCE_BMS_EIS)
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_Get_Patient_Ien_List]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[fn_Get_Patient_Ien_List]
IF TYPE_ID(N'IMPORT_VISTA_CODE_TYPE') IS NOT NULL
	DROP TYPE IMPORT_VISTA_CODE_TYPE
CREATE TYPE IMPORT_VISTA_CODE_TYPE AS TABLE(CODE NVARCHAR(50), ROW_NUM INT) 
	
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_Get_Patient_Ien_List]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[fn_Get_Patient_Ien_List]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_Get_Patient_Ien_List](@SOURCE_IEN_LIST VARCHAR(MAX), @IMPORT_VISTA_CODE IMPORT_VISTA_CODE_TYPE READONLY)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN	
	DECLARE @DESTINATION_IEN_LIST NVARCHAR(MAX), @DELIMITER NVARCHAR(5), @INDEX INT, @POS INT, @SOURCE_VISTA_NAME NVARCHAR(10)
	SET @DELIMITER = '|'
	SET @INDEX = -1

	WHILE (LEN(@SOURCE_IEN_LIST) > 0)
	BEGIN 
		SET @INDEX = CHARINDEX(@DELIMITER , @SOURCE_IEN_LIST) 
		IF (@INDEX = 0) AND (LEN(@SOURCE_IEN_LIST) > 0) 
		BEGIN
			SET @POS  = CHARINDEX('_', @SOURCE_IEN_LIST)  
			SET @SOURCE_VISTA_NAME = SUBSTRING(@SOURCE_IEN_LIST, 1, @POS-1)
  
			IF (SELECT COUNT(*) FROM @IMPORT_VISTA_CODE WHERE CODE = @SOURCE_VISTA_NAME) <> 0  
				BEGIN
					IF(LEN(@DESTINATION_IEN_LIST) > 0)
						SET @DESTINATION_IEN_LIST = @DESTINATION_IEN_LIST + '|' + @SOURCE_IEN_LIST
					ELSE
						SET @DESTINATION_IEN_LIST = @SOURCE_IEN_LIST
				END
			SET @POS = NULL
			SET @SOURCE_VISTA_NAME = NULL			
		BREAK 
		END 

		IF (@INDEX > 1) 
			BEGIN  
				SET @POS  = CHARINDEX('_', LEFT(@SOURCE_IEN_LIST, @INDEX - 1))  
				SET @SOURCE_VISTA_NAME = SUBSTRING(LEFT(@SOURCE_IEN_LIST, @INDEX - 1), 1, @POS-1)
				IF (SELECT COUNT(*) FROM @IMPORT_VISTA_CODE WHERE CODE = @SOURCE_VISTA_NAME) <> 0  
					BEGIN
						IF(LEN(@DESTINATION_IEN_LIST) > 0)
							SET @DESTINATION_IEN_LIST = @DESTINATION_IEN_LIST + '|' + LEFT(@SOURCE_IEN_LIST, @INDEX - 1)
						ELSE
							SET @DESTINATION_IEN_LIST = LEFT(@SOURCE_IEN_LIST, @INDEX - 1)
					END
				SET @SOURCE_IEN_LIST = RIGHT(@SOURCE_IEN_LIST, (LEN(@SOURCE_IEN_LIST) - @INDEX)) 
				SET @POS = NULL
				SET @SOURCE_VISTA_NAME = NULL	
			END 
		ELSE
		   BEGIN
				SET @SOURCE_IEN_LIST = RIGHT(@SOURCE_IEN_LIST, (LEN(@SOURCE_IEN_LIST) - @INDEX))
		   END
	END
	RETURN @DESTINATION_IEN_LIST
	END
GO

SET QUOTED_IDENTIFIER OFF
BEGIN TRY
	BEGIN TRANSACTION;
	DECLARE @SQL NVARCHAR(MAX)
		
		SELECT 'START IMPORT BMS_EIS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)	
		
		-- *** INSERT BMS EIS *** ---		
		DECLARE @IMPORT_VISTA IMPORT_VISTA_CODE_TYPE
		DECLARE @INDEX INT, @TOTAL_VISTA INT, @VISTA_CODE NVARCHAR(20)
		SET @INDEX = 1
		
		CREATE TABLE #ORGANIZATIONS(DESTINATION_ORGANIZATION_PK INT, DESTINATION_ORGANIZATION_UID UNIQUEIDENTIFIER, VISTA_CODE NVARCHAR(10),
						SOURCE_ORGANIZATION_PK INT, SOURCE_ORGANIZATION_UID UNIQUEIDENTIFIER, CODE NVARCHAR(250),STREET_NAME1 VARCHAR(250), STREET_NAME2 VARCHAR(250), CITY VARCHAR(250),
						COUNTRY VARCHAR(250), POSTAL_CODE VARCHAR(250), POC_TELEPHONE VARCHAR(250), POC_EMAIL VARCHAR(250), POINT_OF_CONTACT VARCHAR(250))
		
		--INSERT VISTA
		INSERT INTO #ORGANIZATIONS(DESTINATION_ORGANIZATION_PK, DESTINATION_ORGANIZATION_UID, VISTA_CODE, SOURCE_ORGANIZATION_PK, SOURCE_ORGANIZATION_UID, CODE)
		SELECT DESTINATION_E.PK_ENTITY, DESTINATION_E.IDENTIFIER, UID_SITE.IDENTIFIER_EXTENSION, SOURCE_E.PK_ENTITY, SOURCE_E.IDENTIFIER, DESTINATION_ORG.CODE_CODE
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_E 
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ORGANIZATION AS DESTINATION_ORG ON DESTINATION_ORG.PFK_ORGANIZATION = DESTINATION_E.PK_ENTITY
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS UID_SITE ON DESTINATION_ORG.PFK_ORGANIZATION = UID_SITE.FK_ENTITY AND UID_SITE.IDENTIFIER_ROOT = 'CODE'
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ORGANIZATION AS SOURCE_ORG ON SOURCE_ORG.NAME = DESTINATION_ORG.NAME AND SOURCE_ORG.CODE_CODE = DESTINATION_ORG.CODE_CODE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_E ON SOURCE_E.PK_ENTITY = SOURCE_ORG.PFK_ORGANIZATION
		WHERE DESTINATION_ORG.CODE_CODE ='VST' AND UID_SITE.IDENTIFIER_EXTENSION IN ($(varVISTA_CODES))
		
		INSERT INTO @IMPORT_VISTA(CODE, ROW_NUM)
		SELECT VISTA_CODE, ROW_NUMBER() OVER(ORDER BY VISTA_CODE ASC) AS ROW_NUM
		FROM #ORGANIZATIONS
		WHERE CODE = 'VST'

		SELECT @TOTAL_VISTA = COUNT(*) FROM @IMPORT_VISTA
		
		--INSERT FACILITIES
		INSERT INTO #ORGANIZATIONS(DESTINATION_ORGANIZATION_PK, DESTINATION_ORGANIZATION_UID, SOURCE_ORGANIZATION_PK, SOURCE_ORGANIZATION_UID, CODE)
		SELECT DESTINATION_E.PK_ENTITY, DESTINATION_E.IDENTIFIER, SOURCE_E.PK_ENTITY, SOURCE_E.IDENTIFIER, DESTINATION_ORG.CODE_CODE
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_E 
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ORGANIZATION AS DESTINATION_ORG ON DESTINATION_ORG.PFK_ORGANIZATION = DESTINATION_E.PK_ENTITY
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = DESTINATION_ORG.PFK_ORGANIZATION AND R.CLASS_CODE = 'MBR'
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ORGANIZATION AS SOURCE_ORG ON SOURCE_ORG.NAME = DESTINATION_ORG.NAME AND SOURCE_ORG.CODE_CODE = DESTINATION_ORG.CODE_CODE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_E ON SOURCE_E.PK_ENTITY = SOURCE_ORG.PFK_ORGANIZATION
		INNER JOIN @IMPORT_VISTA AS VISTA ON V.IDENTIFIER_EXTENSION = VISTA.CODE
		WHERE DESTINATION_ORG.CODE_CODE = 'FAC' 

		-- UPDATE FACILITY
		-- GET ADDRESS1
		UPDATE FACILITY
		SET STREET_NAME1 = EA.STREET_NAME,
		CITY = EA.CITY,
		COUNTRY = EA.COUNTRY,
		POSTAL_CODE = EA.POSTAL_CODE
		FROM #ORGANIZATIONS AS FACILITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON FACILITY.SOURCE_ORGANIZATION_PK = E.PK_ENTITY
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_ADDRESS AS EEA ON E.PK_ENTITY = EEA.FK_ENTITY 
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ADDRESS AS EA ON EEA.PK_ENTITY_ADDRESS = EA.PK_ADDRESS 
		WHERE FACILITY.CODE = 'FAC' AND EA.[USE] = 32

		--GET ADDRESS2
		UPDATE FACILITY
		SET STREET_NAME2 = EA.STREET_NAME
		FROM #ORGANIZATIONS AS FACILITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON FACILITY.SOURCE_ORGANIZATION_PK = E.PK_ENTITY
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_ADDRESS AS EEA ON E.PK_ENTITY = EEA.FK_ENTITY 
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ADDRESS AS EA ON EEA.PK_ENTITY_ADDRESS = EA.PK_ADDRESS 
		WHERE FACILITY.CODE = 'FAC' AND EA.[USE] = 8

		--GET EMAIL
		UPDATE FACILITY
		SET POC_EMAIL = ET.TELECOM
		FROM #ORGANIZATIONS AS FACILITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON FACILITY.SOURCE_ORGANIZATION_PK = E.PK_ENTITY
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_TELECOM AS EET ON E.PK_ENTITY = EET.FK_ENTITY 
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_TELECOM AS ET ON EET.PK_ENTITY_TELECOM = ET.PK_TELECOM 
		WHERE FACILITY.CODE = 'FAC' AND ET.CONTACT = 'CONTACT2'

		--GET TELEPHONE
		UPDATE FACILITY
		SET POC_TELEPHONE = ET.TELECOM
		FROM #ORGANIZATIONS AS FACILITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON FACILITY.SOURCE_ORGANIZATION_PK = E.PK_ENTITY
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_TELECOM AS EET ON E.PK_ENTITY = EET.FK_ENTITY 
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_TELECOM AS ET ON EET.PK_ENTITY_TELECOM = ET.PK_TELECOM 
		WHERE FACILITY.CODE = 'FAC' AND ET.CONTACT = 'CONTACT3'

		--GET POINT_OF_CONTACT
		UPDATE FACILITY
		SET POINT_OF_CONTACT = TV.TRAIT_VALUE_STRING
		FROM #ORGANIZATIONS AS FACILITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON FACILITY.SOURCE_ORGANIZATION_PK = E.PK_ENTITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV ON E.PK_ENTITY = TV.FK_ENTITY 
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
		WHERE T.IDENTIFIER = 'POINT_OF_CONTACT'
		
		SELECT 'UPDATE ADDRESS, TELECOM TABLES - FACILITY' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		SET @SQL = NULL
		SELECT @SQL = COALESCE(@SQL, ' ') + '
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(F.DESTINATION_ORGANIZATION_PK AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(F.STREET_NAME1, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=N''' + ISNULL(UPPER(F.CITY), '') + ''',@COUNTY=N''' + ISNULL(UPPER(F.COUNTRY), '') + ''',@COUNTRY=N''' + ISNULL(UPPER(F.COUNTRY), '') + ''',@POSTAL_CODE=N''' + ISNULL(F.POSTAL_CODE, '') + ''',@USE=N''32''
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_ADDRESS @FK_ENTITY=' + CAST(F.DESTINATION_ORGANIZATION_PK AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@HOUSE_NUMBER=NULL,@DIRECTION=NULL,@STREET_NAME=N''' + ISNULL(F.STREET_NAME2, '') + ''',@ADDITIONAL_LOCATOR=NULL,@CITY=NULL,@COUNTY=NULL,@COUNTRY=NULL,@POSTAL_CODE=NULL,@USE=N''8''
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(F.DESTINATION_ORGANIZATION_PK AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''' + ISNULL(F.POC_EMAIL, 'mailto:') + ''',@USE=32,@CONTACT=N''CONTACT2''
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_TELECOM @FK_ENTITY=' + CAST(F.DESTINATION_ORGANIZATION_PK AS NVARCHAR(5)) + ',@FK_ROLE=NULL,@TELECOM=N''' + ISNULL(F.POC_TELEPHONE, 'tel:') + ''',@USE=32,@CONTACT=N''CONTACT3''
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(F.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''POINT_OF_CONTACT'',@TRAIT_VALUE_STRING=N''' + ISNULL(F.POINT_OF_CONTACT, '') + ''',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
		EXEC $(varDESTINATION_BMS_EIS).dbo.UPD_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(F.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Organization'',@TRAIT_IDENTIFIER=N''IS_ALIVE'',@TRAIT_VALUE_STRING=N''TRUE'',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL'	
		FROM #ORGANIZATIONS AS F
		WHERE F.CODE = 'FAC' 
		EXECUTE sp_executesql @SQL
		
		DECLARE @PK_ENTITY_TYPE INT, @PK_DOMAIN INT, @PK_ENTITY_TYPE_ON_DOMAIN INT
		CREATE TABLE #HOSPITAL_LOCATION_AND_DIVISION(PK_DESTINATION INT, PK_SOURCE INT, ORGANIZATION_TYPE NVARCHAR(10))
		--SET DOMAIN
		SELECT @PK_DOMAIN = PK_DOMAIN FROM $(varDESTINATION_BMS_EIS).dbo.DOMAIN WHERE IDENTIFIER = 'InfoWorld'
		--SET ENTITY TYPE
		SELECT @PK_ENTITY_TYPE = PK_ENTITY_TYPE FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE WHERE IDENTIFIER = 'HL7-RIM-V3-Organization'
		--SET ENITY TYPE DOMAIN
		SELECT @PK_ENTITY_TYPE_ON_DOMAIN = PK_ENTITY_TYPE_ON_DOMAIN
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE_ON_DOMAIN WHERE FK_DOMAIN = @PK_DOMAIN AND FK_ENTITY_TYPE = @PK_ENTITY_TYPE;
		
	    --INSERT ENTITY (HOS. LOCATION)
		SELECT 'INSERT ENTITY HOS. LOCATION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_TABLE
		USING (SELECT E.*, O.CODE_CODE AS ORGANIZATION_TYPE
			  FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS E
			  INNER JOIN $(varSOURCE_BMS_EIS).dbO.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
			  INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = O.PFK_ORGANIZATION AND R.CLASS_CODE = 'MBR'
			  INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
			  INNER JOIN @IMPORT_VISTA AS VISTA ON V.IDENTIFIER_EXTENSION = VISTA.CODE
			  WHERE O.CODE_CODE ='HLOC')SOURCE_TABLE
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES(IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM,
		STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		OUTPUT
		INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY, SOURCE_TABLE.ORGANIZATION_TYPE 
		INTO #HOSPITAL_LOCATION_AND_DIVISION(PK_DESTINATION, PK_SOURCE, ORGANIZATION_TYPE);
	
		--INSERT ENTITY (DIVISION)
		SELECT 'INSERT ENTITY DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_TABLE
		USING (SELECT E.*, O.CODE_CODE AS ORGANIZATION_TYPE
				FROM $(varSOURCE_BMS_EIS).[dbo].[EHL7_ORGANIZATION] AS O
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
				INNER JOIN $(varSOURCE_BMS_EIS).[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
				INNER JOIN #ORGANIZATIONS AS FAC ON R.FK_SCOPER_ENTITY = FAC.SOURCE_ORGANIZATION_PK
				WHERE O.CODE_CODE ='WGR')SOURCE_TABLE
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES(IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM,
		STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		OUTPUT
		INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY, SOURCE_TABLE.ORGANIZATION_TYPE 
		INTO #HOSPITAL_LOCATION_AND_DIVISION(PK_DESTINATION, PK_SOURCE, ORGANIZATION_TYPE);

		--INSERT ORGANISATION (HOS. LOCATION AND DIVISION)
		SELECT 'INSERT EHL7_ORGANIZATION TABLE - HOS. LOCATION AND DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.[EHL7_ORGANIZATION]([PFK_ORGANIZATION],[IDENTIFIER_ROOT],[IDENTIFIER_EXTENSION],[CODE_CODE]
      ,[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[DESCRIPTION],[NAME],[NAME_PREFIX],[NAME_SUFFIX]
      ,[STANDARD_INDUSTRY_CLASS_CODE],[STANDARD_INDUSTRY_CLASS_CODE_SYSTEM],[STANDARD_INDUSTRY_CLASS_CODE_SYSTEM_NAME]
      ,[STANDARD_INDUSTRY_CLASS_DISPLAY_NAME],[EXISTENCE_TIME_LOW],[EXISTENCE_TIME_HIGH],[RISK_CODE],[RISK_CODE_SYSTEM]
      ,[RISK_CODE_SYSTEM_NAME],[RISK_DISPLAY_NAME],[HANDLING_CODE],[HANDLING_CODE_SYSTEM],[HANDLING_CODE_SYSTEM_NAME]
      ,[HANDLING_DISPLAY_NAME]) 
		SELECT NEW_O.PK_DESTINATION, OLD_O.IDENTIFIER_ROOT, OLD_O.IDENTIFIER_EXTENSION, OLD_O.CODE_CODE, OLD_O.CODE_CODE_SYSTEM
      ,OLD_O.CODE_CODE_SYSTEM_NAME, OLD_O.CODE_DISPLAY_NAME, OLD_O.[DESCRIPTION], OLD_O.[NAME], OLD_O.[NAME_PREFIX]
      ,OLD_O.[NAME_SUFFIX], OLD_O.[STANDARD_INDUSTRY_CLASS_CODE], OLD_O.[STANDARD_INDUSTRY_CLASS_CODE_SYSTEM]
      ,OLD_O.[STANDARD_INDUSTRY_CLASS_CODE_SYSTEM_NAME], OLD_O.[STANDARD_INDUSTRY_CLASS_DISPLAY_NAME]
		  ,OLD_O.[EXISTENCE_TIME_LOW], OLD_O.[EXISTENCE_TIME_HIGH], OLD_O.[RISK_CODE], OLD_O.[RISK_CODE_SYSTEM], OLD_O.[RISK_CODE_SYSTEM_NAME]
      ,OLD_O.[RISK_DISPLAY_NAME], OLD_O.[HANDLING_CODE], OLD_O.[HANDLING_CODE_SYSTEM],OLD_O.[HANDLING_CODE_SYSTEM_NAME]
      ,OLD_O.[HANDLING_DISPLAY_NAME] 
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ORGANIZATION AS OLD_O
		INNER JOIN #HOSPITAL_LOCATION_AND_DIVISION AS NEW_O ON OLD_O.PFK_ORGANIZATION = NEW_O.PK_SOURCE 
		
		--INSERT UIDS (HOS. LOCATION AND DIVISION)
		SELECT 'INSERT EHL7_UID TABLE - HOS. LOCATION AND DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_UID (FK_ENTITY,IDENTIFIER_ROOT,IDENTIFIER_EXTENSION)
		SELECT NEW_O.PK_DESTINATION, O_UID.IDENTIFIER_ROOT, O_UID.IDENTIFIER_EXTENSION 
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS O_UID
		INNER JOIN #HOSPITAL_LOCATION_AND_DIVISION AS NEW_O ON O_UID.FK_ENTITY = NEW_O.PK_SOURCE 
		
		--INSERT TRAITS (HOS. LOCATION AND DIVISION)
		SELECT 'INSERT TRAIT_VALUE TABLE - HOS. LOCATION AND DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE(FK_ENTITY, FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TRAIT_VALUE_STRING, 
			TRAIT_VALUE_REAL, TRAIT_VALUE_INTEGER, TRAIT_VALUE_DATETIME, TRAIT_VALUE_BYTE)
		SELECT NEW_O.PK_DESTINATION, TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TV.TRAIT_VALUE_STRING, 
			TV.TRAIT_VALUE_REAL, TV.TRAIT_VALUE_INTEGER, TV.TRAIT_VALUE_DATETIME, TV.TRAIT_VALUE_BYTE
		FROM $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV
		INNER JOIN #HOSPITAL_LOCATION_AND_DIVISION AS NEW_O ON TV.FK_ENTITY = NEW_O.PK_SOURCE
		
		--INSERT TELECOM
		SELECT 'INSERT EHL7_TELECOM TABLE - HOS.LOCATION ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		CREATE TABLE #TELECOM(PK_DESTINATION INT, PK_SOURCE INT);
		MERGE $(varDESTINATION_BMS_EIS).dbo.EHL7_TELECOM AS DESTINATION_TABLE
		USING (SELECT ET.*
			  FROM #HOSPITAL_LOCATION_AND_DIVISION AS ENTITY
			  INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_TELECOM AS EET ON ENTITY.PK_SOURCE = EET.FK_ENTITY
			  INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_TELECOM AS ET ON EET.FK_TELECOM = ET.PK_TELECOM
			  WHERE ENTITY.ORGANIZATION_TYPE ='HLOC' ) SOURCE_TABLE
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT (TELECOM,[USE],CONTACT)
		VALUES(SOURCE_TABLE.TELECOM, SOURCE_TABLE.[USE], SOURCE_TABLE.CONTACT)
		OUTPUT
		INSERTED.PK_TELECOM, SOURCE_TABLE.PK_TELECOM
		INTO #TELECOM(PK_DESTINATION, PK_SOURCE);
		
		SELECT 'INSERT [EHL7_ENTITY_TELECOM] TABLE - HOS.LOCATION ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.[EHL7_ENTITY_TELECOM]
				([FK_ENTITY] ,[FK_TELECOM])
		SELECT ORG.PK_DESTINATION, T.PK_DESTINATION 
		FROM #HOSPITAL_LOCATION_AND_DIVISION AS ORG 
		INNER JOIN  $(varSOURCE_BMS_EIS).dbo.EHL7_ENTITY_TELECOM AS EET ON ORG.PK_SOURCE = EET.FK_ENTITY 
		INNER JOIN #TELECOM AS T ON EET.FK_TELECOM = T.PK_SOURCE

		DROP TABLE #TELECOM
		
	   --INSERT ROLE HOS.LOCATION - VISTA, DIVISION - FACILITY
		SELECT 'INSERT EHL7_ROLE TABLE - ROLE HOS.LOCATION - VISTA, DIVISION - FACILITY' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])	  
		SELECT PLAYER.PK_DESTINATION, SCOPER.DESTINATION_ORGANIZATION_PK, ORG_ROLE.CLASS_CODE, ORG_ROLE.CLASS_CODE_SYSTEM, 
			  ORG_ROLE.CLASS_CODE_SYSTEM_NAME, ORG_ROLE.CLASS_DISPLAY_NAME, ORG_ROLE.CODE_CODE, ORG_ROLE.CODE_CODE_SYSTEM, ORG_ROLE.CODE_CODE_SYSTEM_NAME, 
			  ORG_ROLE.CODE_DISPLAY_NAME, ORG_ROLE.NEGATION_IND, ORG_ROLE.NAME_FAMILY, ORG_ROLE.NAME_FIRST_GIVEN, ORG_ROLE.NAME_SECOND_GIVEN, 
			  ORG_ROLE.NAME_PREFIX, ORG_ROLE.NAME_SUFFIX, ORG_ROLE.STATUS_CODE, ORG_ROLE.STATUS_CODE_SYSTEM, ORG_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  ORG_ROLE.STATUS_DISPLAY_NAME, ORG_ROLE.EFFECTIVE_TIME_LOW, ORG_ROLE.EFFECTIVE_TIME_HIGH, ORG_ROLE.CERTIFICATE_TEXT, 
			  ORG_ROLE.CONFIDENTIALITY_CODE, ORG_ROLE.CONFIDENTIALITY_CODE_SYSTEM, ORG_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  ORG_ROLE.CONFIDENTIALITY_DISPLAY_NAME, ORG_ROLE.QUANTITY_NUMERATOR_VALUE, ORG_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  ORG_ROLE.QUANTITY_DENOMINATOR_VALUE, ORG_ROLE.QUANTITY_DENOMINATOR_UNIT, ORG_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS ORG_ROLE 
		INNER JOIN #HOSPITAL_LOCATION_AND_DIVISION AS PLAYER ON ORG_ROLE.FK_PLAYER_ENTITY = PLAYER.PK_SOURCE 
		INNER JOIN #ORGANIZATIONS AS SCOPER ON ORG_ROLE.FK_SCOPER_ENTITY = SCOPER.SOURCE_ORGANIZATION_PK
		
		DROP TABLE #HOSPITAL_LOCATION_AND_DIVISION

		--INSERT PLACE (WARD AND BED)
		SET @PK_ENTITY_TYPE = NULL
		SET @PK_ENTITY_TYPE_ON_DOMAIN = NULL
		SELECT @PK_ENTITY_TYPE = PK_ENTITY_TYPE FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE WHERE IDENTIFIER = 'HL7-RIM-V3-Place'

		SELECT @PK_ENTITY_TYPE_ON_DOMAIN = PK_ENTITY_TYPE_ON_DOMAIN
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE_ON_DOMAIN WHERE FK_DOMAIN = @PK_DOMAIN AND FK_ENTITY_TYPE = @PK_ENTITY_TYPE
		
		CREATE TABLE #PLACE(PK_DESTINATION INT, PK_SOURCE INT, ORGANIZATION_TYPE NVARCHAR(10))

		--INSERT ENTITY (WARD)
		SELECT 'INSERT ENTITY WARD' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_TABLE
		USING (SELECT E.*, P.CODE_CODE AS ORGANIZATION_TYPE
				FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS E
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_PLACE AS P ON E.PK_ENTITY = P.PFK_PLACE
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'OWN'
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
				INNER JOIN @IMPORT_VISTA AS VISTA ON V.IDENTIFIER_EXTENSION = VISTA.CODE
				WHERE P.CODE_CODE ='WRD'
				)SOURCE_TABLE
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES(IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM,
		STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		OUTPUT
		INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY, SOURCE_TABLE.ORGANIZATION_TYPE 
		INTO #PLACE(PK_DESTINATION, PK_SOURCE, ORGANIZATION_TYPE);
		
		--INSERT ENTITY(BED)
		SELECT 'INSERT ENTITY BED' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_TABLE
		USING ( SELECT E.*, P.CODE_CODE AS ORGANIZATION_TYPE
				FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS E
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_PLACE AS P ON E.PK_ENTITY = P.PFK_PLACE
				INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS VISTA_UID ON E.PK_ENTITY = VISTA_UID.FK_ENTITY AND VISTA_UID.IDENTIFIER_ROOT = 'SITE'
				INNER JOIN #ORGANIZATIONS AS VISTA ON VISTA_UID.IDENTIFIER_EXTENSION = VISTA.SOURCE_ORGANIZATION_UID
				WHERE P.CODE_CODE ='BED')SOURCE_TABLE
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES(IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM,
		STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		OUTPUT
		INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY, SOURCE_TABLE.ORGANIZATION_TYPE 
		INTO #PLACE(PK_DESTINATION, PK_SOURCE, ORGANIZATION_TYPE);

		--INSERT WARD
		SELECT 'INSERT EHL7_PLACE TABLE - WARD' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_PLACE(PFK_PLACE, IDENTIFIER_ROOT, IDENTIFIER_EXTENSION, CODE_CODE, CODE_CODE_SYSTEM, CODE_CODE_SYSTEM_NAME,
		  CODE_DISPLAY_NAME, [DESCRIPTION], NAME, MOBILE_IND, DIRECTIONS_TEXT, POSITION_TEXT, GPS_TEXT, EXISTENCE_TIME_LOW, EXISTENCE_TIME_HIGH,
		  RISK_CODE, RISK_CODE_SYSTEM, RISK_CODE_SYSTEM_NAME, RISK_DISPLAY_NAME, HANDLING_CODE, HANDLING_CODE_SYSTEM, HANDLING_CODE_SYSTEM_NAME,
		  HANDLING_DISPLAY_NAME)   
		SELECT DESTINATION_PK.PK_DESTINATION, NULL, NULL, 'WRD', '2.12.24.40', 'OrganizationChart', 'WARD',NULL, WARD_P.NAME ,NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL		
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_PLACE AS WARD_P 
		INNER JOIN #PLACE AS DESTINATION_PK ON WARD_P.PFK_PLACE = DESTINATION_PK.PK_SOURCE
		WHERE DESTINATION_PK.ORGANIZATION_TYPE = 'WRD'	
		
		--INSERT BED
		SELECT 'INSERT EHL7_PLACE TABLE - BED' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_PLACE(PFK_PLACE, IDENTIFIER_ROOT, IDENTIFIER_EXTENSION, CODE_CODE, CODE_CODE_SYSTEM, CODE_CODE_SYSTEM_NAME,
		  CODE_DISPLAY_NAME, [DESCRIPTION], NAME, MOBILE_IND, DIRECTIONS_TEXT, POSITION_TEXT, GPS_TEXT, EXISTENCE_TIME_LOW, EXISTENCE_TIME_HIGH,
		  RISK_CODE, RISK_CODE_SYSTEM, RISK_CODE_SYSTEM_NAME, RISK_DISPLAY_NAME, HANDLING_CODE, HANDLING_CODE_SYSTEM, HANDLING_CODE_SYSTEM_NAME,
		  HANDLING_DISPLAY_NAME)   
		SELECT DESTINATION_PK.PK_DESTINATION, NULL, NULL, 'BED', '2.12.24.40', 'OrganizationChart', 'BED',NULL,BED_P.NAME ,NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL		
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_PLACE AS BED_P 
		INNER JOIN #PLACE AS DESTINATION_PK ON BED_P.PFK_PLACE = DESTINATION_PK.PK_SOURCE
		WHERE DESTINATION_PK.ORGANIZATION_TYPE = 'BED'	

		--INSERT TRAITS WARD AND BED
		SELECT 'INSERT TRAIT_VALUE TABLE - WARD - BED' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE(FK_ENTITY, FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TRAIT_VALUE_STRING, 
			TRAIT_VALUE_REAL, TRAIT_VALUE_INTEGER, TRAIT_VALUE_DATETIME, TRAIT_VALUE_BYTE)
		SELECT PLACE.PK_DESTINATION, TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TV.TRAIT_VALUE_STRING, 
			TV.TRAIT_VALUE_REAL, TV.TRAIT_VALUE_INTEGER, TV.TRAIT_VALUE_DATETIME, TV.TRAIT_VALUE_BYTE
		FROM $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV
		INNER JOIN #PLACE AS PLACE ON TV.FK_ENTITY = PLACE.PK_SOURCE

		--INSERT UIDS WARD AND BED
		SELECT 'INSERT EHL7_UID TABLE - WARD - BED' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_UID (FK_ENTITY,IDENTIFIER_ROOT,IDENTIFIER_EXTENSION)
		SELECT PLACE.PK_DESTINATION, PLACE_UID.IDENTIFIER_ROOT,
				CASE WHEN VISTA.DESTINATION_ORGANIZATION_UID IS NOT NULL THEN CAST(VISTA.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))
					 ELSE PLACE_UID.IDENTIFIER_EXTENSION
				END
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PLACE_UID
		INNER JOIN #PLACE AS PLACE ON PLACE_UID.FK_ENTITY = PLACE.PK_SOURCE
		LEFT JOIN #ORGANIZATIONS AS VISTA ON CAST(VISTA.SOURCE_ORGANIZATION_UID AS NVARCHAR(50)) = PLACE_UID.IDENTIFIER_EXTENSION

		--INSERT ROLE WARD - VISTA
		SELECT 'INSERT EHL7_ROLE TABLE - ROLE WARD - VISTA' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])	  
		SELECT PLACE.PK_DESTINATION,VISTA.DESTINATION_ORGANIZATION_PK, WARD_ROLE.CLASS_CODE, WARD_ROLE.CLASS_CODE_SYSTEM, 
			  WARD_ROLE.CLASS_CODE_SYSTEM_NAME, WARD_ROLE.CLASS_DISPLAY_NAME, WARD_ROLE.CODE_CODE, WARD_ROLE.CODE_CODE_SYSTEM, WARD_ROLE.CODE_CODE_SYSTEM_NAME, 
			  WARD_ROLE.CODE_DISPLAY_NAME, WARD_ROLE.NEGATION_IND, WARD_ROLE.NAME_FAMILY, WARD_ROLE.NAME_FIRST_GIVEN, WARD_ROLE.NAME_SECOND_GIVEN, 
			  WARD_ROLE.NAME_PREFIX, WARD_ROLE.NAME_SUFFIX, WARD_ROLE.STATUS_CODE, WARD_ROLE.STATUS_CODE_SYSTEM, WARD_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  WARD_ROLE.STATUS_DISPLAY_NAME, WARD_ROLE.EFFECTIVE_TIME_LOW, WARD_ROLE.EFFECTIVE_TIME_HIGH, WARD_ROLE.CERTIFICATE_TEXT, 
			  WARD_ROLE.CONFIDENTIALITY_CODE, WARD_ROLE.CONFIDENTIALITY_CODE_SYSTEM, WARD_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  WARD_ROLE.CONFIDENTIALITY_DISPLAY_NAME, WARD_ROLE.QUANTITY_NUMERATOR_VALUE, WARD_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  WARD_ROLE.QUANTITY_DENOMINATOR_VALUE, WARD_ROLE.QUANTITY_DENOMINATOR_UNIT, WARD_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS WARD_ROLE 
		INNER JOIN #PLACE AS PLACE ON WARD_ROLE.FK_PLAYER_ENTITY = PLACE.PK_SOURCE
		INNER JOIN #ORGANIZATIONS AS VISTA ON WARD_ROLE.FK_SCOPER_ENTITY = VISTA.SOURCE_ORGANIZATION_PK
		WHERE PLACE.ORGANIZATION_TYPE = 'WRD' AND WARD_ROLE.CLASS_CODE = 'OWN'

		--INSERT ROLE WARD - DIVISION
		SELECT 'INSERT EHL7_ROLE TABLE - ROLE WARD - DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])		  
		SELECT PLACE.PK_DESTINATION, DESTINATION_SCOPER_ENTITY.PK_ENTITY, WARD_ROLE.CLASS_CODE, WARD_ROLE.CLASS_CODE_SYSTEM, 
			  WARD_ROLE.CLASS_CODE_SYSTEM_NAME, WARD_ROLE.CLASS_DISPLAY_NAME, WARD_ROLE.CODE_CODE, WARD_ROLE.CODE_CODE_SYSTEM, WARD_ROLE.CODE_CODE_SYSTEM_NAME, 
			  WARD_ROLE.CODE_DISPLAY_NAME, WARD_ROLE.NEGATION_IND, WARD_ROLE.NAME_FAMILY, WARD_ROLE.NAME_FIRST_GIVEN, WARD_ROLE.NAME_SECOND_GIVEN, 
			  WARD_ROLE.NAME_PREFIX, WARD_ROLE.NAME_SUFFIX, WARD_ROLE.STATUS_CODE, WARD_ROLE.STATUS_CODE_SYSTEM, WARD_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  WARD_ROLE.STATUS_DISPLAY_NAME, WARD_ROLE.EFFECTIVE_TIME_LOW, WARD_ROLE.EFFECTIVE_TIME_HIGH, WARD_ROLE.CERTIFICATE_TEXT, 
			  WARD_ROLE.CONFIDENTIALITY_CODE, WARD_ROLE.CONFIDENTIALITY_CODE_SYSTEM, WARD_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  WARD_ROLE.CONFIDENTIALITY_DISPLAY_NAME, WARD_ROLE.QUANTITY_NUMERATOR_VALUE, WARD_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  WARD_ROLE.QUANTITY_DENOMINATOR_VALUE, WARD_ROLE.QUANTITY_DENOMINATOR_UNIT, WARD_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS WARD_ROLE 
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_SCOPER_ENTITY ON WARD_ROLE.FK_SCOPER_ENTITY = SOURCE_SCOPER_ENTITY.PK_ENTITY
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_SCOPER_ENTITY ON SOURCE_SCOPER_ENTITY.IDENTIFIER = DESTINATION_SCOPER_ENTITY.IDENTIFIER
		INNER JOIN #PLACE AS PLACE ON WARD_ROLE.FK_PLAYER_ENTITY = PLACE.PK_SOURCE
		WHERE PLACE.ORGANIZATION_TYPE = 'WRD' AND WARD_ROLE.CLASS_CODE = 'SDLOC'

		--INSERT ROLE BED - WARD, BED - DIVISION
		SELECT 'INSERT EHL7_ROLE TABLE - ROLE BED - WARD, BED - DIVISION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])		  
		SELECT PLACE.PK_DESTINATION, DESTINATION_SCOPER_ENTITY.PK_ENTITY, BED_ROLE.CLASS_CODE, BED_ROLE.CLASS_CODE_SYSTEM, 
			  BED_ROLE.CLASS_CODE_SYSTEM_NAME, BED_ROLE.CLASS_DISPLAY_NAME, BED_ROLE.CODE_CODE, BED_ROLE.CODE_CODE_SYSTEM, BED_ROLE.CODE_CODE_SYSTEM_NAME, 
			  BED_ROLE.CODE_DISPLAY_NAME, BED_ROLE.NEGATION_IND, BED_ROLE.NAME_FAMILY, BED_ROLE.NAME_FIRST_GIVEN, BED_ROLE.NAME_SECOND_GIVEN, 
			  BED_ROLE.NAME_PREFIX, BED_ROLE.NAME_SUFFIX, BED_ROLE.STATUS_CODE, BED_ROLE.STATUS_CODE_SYSTEM, BED_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  BED_ROLE.STATUS_DISPLAY_NAME, BED_ROLE.EFFECTIVE_TIME_LOW, BED_ROLE.EFFECTIVE_TIME_HIGH, BED_ROLE.CERTIFICATE_TEXT, 
			  BED_ROLE.CONFIDENTIALITY_CODE, BED_ROLE.CONFIDENTIALITY_CODE_SYSTEM, BED_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  BED_ROLE.CONFIDENTIALITY_DISPLAY_NAME, BED_ROLE.QUANTITY_NUMERATOR_VALUE, BED_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  BED_ROLE.QUANTITY_DENOMINATOR_VALUE, BED_ROLE.QUANTITY_DENOMINATOR_UNIT, BED_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS BED_ROLE 
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_SCOPER_ENTITY ON BED_ROLE.FK_SCOPER_ENTITY = SOURCE_SCOPER_ENTITY.PK_ENTITY
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_SCOPER_ENTITY ON SOURCE_SCOPER_ENTITY.IDENTIFIER = DESTINATION_SCOPER_ENTITY.IDENTIFIER
		INNER JOIN #PLACE AS PLACE ON BED_ROLE.FK_PLAYER_ENTITY = PLACE.PK_SOURCE
		WHERE PLACE.ORGANIZATION_TYPE = 'BED'
		
		DROP TABLE #PLACE

		-- *** UPDATE PATIENT *** --
		CREATE TABLE #UPDATE_PATIENT(DESTINATION_PK INT, SOURCE_PK INT, IEN_LIST NVARCHAR(MAX))
		
		WHILE (@INDEX <=@TOTAL_VISTA)
		BEGIN
			
			SELECT @VISTA_CODE = CODE FROM @IMPORT_VISTA WHERE ROW_NUM = @INDEX
			INSERT INTO #UPDATE_PATIENT(DESTINATION_PK, SOURCE_PK, IEN_LIST)
			SELECT DESTINATION_PATIENT_SSN.FK_ENTITY, SOURCE_ENTITY.PK_ENTITY, TV.TRAIT_VALUE_STRING
			FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY 
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS SOURCE_ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = SOURCE_ROLE_PATIENT.FK_PLAYER_ENTITY
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS SOURCE_PATIENT_SSN ON SOURCE_ROLE_PATIENT.FK_PLAYER_ENTITY = SOURCE_PATIENT_SSN.FK_ENTITY AND SOURCE_PATIENT_SSN.IDENTIFIER_ROOT = 'SSN'
			INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS DESTINATION_PATIENT_SSN ON SOURCE_PATIENT_SSN.IDENTIFIER_EXTENSION = DESTINATION_PATIENT_SSN.IDENTIFIER_EXTENSION AND DESTINATION_PATIENT_SSN.IDENTIFIER_ROOT = 'SSN'
			INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE AS DESTINATION_ROLE_PATIENT ON DESTINATION_PATIENT_SSN.FK_ENTITY = DESTINATION_ROLE_PATIENT.FK_PLAYER_ENTITY
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = SOURCE_PATIENT_SSN.FK_ENTITY
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
			LEFT OUTER JOIN #UPDATE_PATIENT AS UPD ON DESTINATION_PATIENT_SSN.FK_ENTITY = UPD.DESTINATION_PK
			WHERE UPD.DESTINATION_PK IS NULL AND SOURCE_ROLE_PATIENT.CLASS_CODE = 'PAT' AND DESTINATION_ROLE_PATIENT.CLASS_CODE = 'PAT' AND T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%'		
			SET @INDEX = @INDEX + 1
		END
		
		UPDATE UPD
			SET IEN_LIST = $(varSOURCE_BMS_EIS).dbo.fn_Get_Patient_Ien_List(UPD.IEN_LIST, @IMPORT_VISTA)
		FROM #UPDATE_PATIENT AS UPD
			
		--UPDATE ENTITY
		SELECT 'UPDATE ENTITY TABLE - PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		UPDATE ENTITY
		SET 
		LAST_MODIFICATION_TIME = SOURCE_ENTITY.LAST_MODIFICATION_TIME,
		TRANSACTION_ID = SOURCE_ENTITY.TRANSACTION_ID
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY AS ENTITY
		INNER JOIN #UPDATE_PATIENT AS UPD ON ENTITY.PK_ENTITY = UPD.DESTINATION_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY ON UPD.SOURCE_PK = SOURCE_ENTITY.PK_ENTITY

		--UPDATE PATIENT
		SELECT 'UPDATE EHL7_PERSON TABLE - PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		UPDATE DESTINATION_PATIENT
		SET [CODE_CODE] = SOURCE_PATIENT.CODE_CODE
		 ,[CODE_CODE_SYSTEM] = SOURCE_PATIENT.CODE_CODE_SYSTEM
		 ,[CODE_CODE_SYSTEM_NAME] = SOURCE_PATIENT.CODE_CODE_SYSTEM_NAME
		 ,[CODE_DISPLAY_NAME] = SOURCE_PATIENT.CODE_DISPLAY_NAME
		 ,[DESCRIPTION] = SOURCE_PATIENT.DESCRIPTION
		 ,[ADMINISTRATIVE_GENDER_CODE] = SOURCE_PATIENT.ADMINISTRATIVE_GENDER_CODE
		 ,[ADMINISTRATIVE_GENDER_CODE_SYSTEM] = SOURCE_PATIENT.ADMINISTRATIVE_GENDER_CODE_SYSTEM
		 ,[ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME] = SOURCE_PATIENT.ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME
		 ,[ADMINISTRATIVE_GENDER_DISPLAY_NAME] = SOURCE_PATIENT.ADMINISTRATIVE_GENDER_DISPLAY_NAME
		 ,[BIRTH_TIME] = SOURCE_PATIENT.BIRTH_TIME
		 ,[DECEASED_IND] = SOURCE_PATIENT.DECEASED_IND
		 ,[DECEASED_TIME] = SOURCE_PATIENT.DECEASED_TIME
		 ,[MULTIPLE_BIRTH_IND] = SOURCE_PATIENT.MULTIPLE_BIRTH_IND
		 ,[MULTIPLE_BIRTH_ORDER_NUMBER] = SOURCE_PATIENT.MULTIPLE_BIRTH_ORDER_NUMBER
		 ,[ORGAN_DONOR_IND] = SOURCE_PATIENT.ORGAN_DONOR_IND
		 ,[NAME_FAMILY] = SOURCE_PATIENT.NAME_FAMILY
		 ,[NAME_FIRST_GIVEN] = SOURCE_PATIENT.NAME_FIRST_GIVEN
		 ,[NAME_SECOND_GIVEN] = SOURCE_PATIENT.NAME_SECOND_GIVEN
		 ,[NAME_PREFIX] = SOURCE_PATIENT.NAME_PREFIX
		 ,[NAME_SUFFIX] = SOURCE_PATIENT.NAME_SUFFIX
		 ,[MARITAL_STATUS_CODE] = SOURCE_PATIENT.MARITAL_STATUS_CODE
		 ,[MARITAL_STATUS_CODE_SYSTEM] = SOURCE_PATIENT.MARITAL_STATUS_CODE_SYSTEM
		 ,[MARITAL_STATUS_CODE_SYSTEM_NAME] = SOURCE_PATIENT.MARITAL_STATUS_CODE_SYSTEM_NAME
		 ,[MARITAL_STATUS_DISPLAY_NAME] = SOURCE_PATIENT.MARITAL_STATUS_DISPLAY_NAME
		 ,[EDUCATION_LEVEL_CODE] = SOURCE_PATIENT.EDUCATION_LEVEL_CODE
		 ,[EDUCATION_LEVEL_CODE_SYSTEM] = SOURCE_PATIENT.EDUCATION_LEVEL_CODE_SYSTEM
		 ,[EDUCATION_LEVEL_CODE_SYSTEM_NAME] = SOURCE_PATIENT.EDUCATION_LEVEL_CODE_SYSTEM_NAME
		 ,[EDUCATION_LEVEL_DISPLAY_NAME] = SOURCE_PATIENT.EDUCATION_LEVEL_DISPLAY_NAME
		 ,[RACE_CODE] = SOURCE_PATIENT.RACE_CODE
		 ,[RACE_CODE_SYSTEM] = SOURCE_PATIENT.RACE_CODE_SYSTEM
		 ,[RACE_CODE_SYSTEM_NAME] = SOURCE_PATIENT.RACE_CODE_SYSTEM_NAME
		 ,[RACE_DISPLAY_NAME] = SOURCE_PATIENT.RACE_DISPLAY_NAME
		 ,[DISABILITY_CODE] = SOURCE_PATIENT.DISABILITY_CODE
		 ,[DISABILITY_CODE_SYSTEM] = SOURCE_PATIENT.DISABILITY_CODE_SYSTEM
		 ,[DISABILITY_CODE_SYSTEM_NAME] = SOURCE_PATIENT.DISABILITY_CODE_SYSTEM_NAME
		 ,[DISABILITY_DISPLAY_NAME] = SOURCE_PATIENT.DISABILITY_DISPLAY_NAME
		 ,[LIVING_ARRANGEMENT_CODE] = SOURCE_PATIENT.LIVING_ARRANGEMENT_CODE
		 ,[LIVING_ARRANGEMENT_CODE_SYSTEM] = SOURCE_PATIENT.LIVING_ARRANGEMENT_CODE_SYSTEM
		 ,[LIVING_ARRANGEMENT_CODE_SYSTEM_NAME] = SOURCE_PATIENT.LIVING_ARRANGEMENT_CODE_SYSTEM_NAME
		 ,[LIVING_ARRANGEMENT_DISPLAY_NAME] = SOURCE_PATIENT.LIVING_ARRANGEMENT_DISPLAY_NAME
		 ,[RELIGIOUS_AFFILIATION_CODE] = SOURCE_PATIENT.RELIGIOUS_AFFILIATION_CODE
		 ,[RELIGIOUS_AFFILIATION_CODE_SYSTEM] = SOURCE_PATIENT.RELIGIOUS_AFFILIATION_CODE_SYSTEM
		 ,[RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME] = SOURCE_PATIENT.RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME
		 ,[RELIGIOUS_AFFILIATION_DISPLAY_NAME] = SOURCE_PATIENT.RELIGIOUS_AFFILIATION_DISPLAY_NAME
		 ,[ETHNIC_GROUP_CODE] = SOURCE_PATIENT.ETHNIC_GROUP_CODE
		 ,[ETHNIC_GROUP_CODE_SYSTEM] = SOURCE_PATIENT.ETHNIC_GROUP_CODE_SYSTEM
		 ,[ETHNIC_GROUP_CODE_SYSTEM_NAME] = SOURCE_PATIENT.ETHNIC_GROUP_CODE_SYSTEM_NAME
		 ,[ETHNIC_GROUP_DISPLAY_NAME] = SOURCE_PATIENT.ETHNIC_GROUP_DISPLAY_NAME
		 ,[EXISTENCE_TIME_LOW] = SOURCE_PATIENT.EXISTENCE_TIME_LOW
		 ,[EXISTENCE_TIME_HIGH] = SOURCE_PATIENT.EXISTENCE_TIME_HIGH
		 ,[RISK_CODE] = SOURCE_PATIENT.RISK_CODE
		 ,[RISK_CODE_SYSTEM] = SOURCE_PATIENT.RISK_CODE_SYSTEM
		 ,[RISK_CODE_SYSTEM_NAME] = SOURCE_PATIENT.RISK_CODE_SYSTEM_NAME
		 ,[RISK_DISPLAY_NAME] = SOURCE_PATIENT.RISK_DISPLAY_NAME
		 ,[HANDLING_CODE] = SOURCE_PATIENT.HANDLING_CODE
		 ,[HANDLING_CODE_SYSTEM] = SOURCE_PATIENT.HANDLING_CODE_SYSTEM
		 ,[HANDLING_CODE_SYSTEM_NAME] = SOURCE_PATIENT.HANDLING_CODE_SYSTEM_NAME
		 ,[HANDLING_DISPLAY_NAME] = SOURCE_PATIENT.HANDLING_DISPLAY_NAME	
		FROM $(varDESTINATION_BMS_EIS).dbo.EHL7_PERSON AS DESTINATION_PATIENT
		INNER JOIN #UPDATE_PATIENT AS UPD_PATIENT ON DESTINATION_PATIENT.PFK_PERSON = UPD_PATIENT.DESTINATION_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_PERSON AS SOURCE_PATIENT ON UPD_PATIENT.SOURCE_PK = SOURCE_PATIENT.PFK_PERSON

		--UPDATE TRAITS
		SELECT 'UPDATE TRAIT_VALUE TABLE (ALL TRAITS EXCEPT IEN_LIST TRAIT) - PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		UPDATE DESTINATION_TV
		SET [TRAIT_VALUE_STRING] = SOURCE_TV.TRAIT_VALUE_STRING
		,[TRAIT_VALUE_REAL] = SOURCE_TV.TRAIT_VALUE_REAL
		,[TRAIT_VALUE_INTEGER] = SOURCE_TV.TRAIT_VALUE_INTEGER
		,[TRAIT_VALUE_DATETIME] = SOURCE_TV.TRAIT_VALUE_DATETIME
		,[TRAIT_VALUE_BYTE] = SOURCE_TV.TRAIT_VALUE_BYTE
		FROM $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE AS DESTINATION_TV
		INNER JOIN #UPDATE_PATIENT AS UPD_PATIENT ON DESTINATION_TV.FK_ENTITY = UPD_PATIENT.DESTINATION_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS SOURCE_TV ON UPD_PATIENT.SOURCE_PK = SOURCE_TV.FK_ENTITY AND DESTINATION_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE 
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS SOURCE_TAET ON SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = SOURCE_TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS SOURCE_T ON SOURCE_TAET.FK_TRAIT = SOURCE_T.PK_TRAIT
		WHERE SOURCE_T.IDENTIFIER <> 'IEN_LIST'

		--UPDATE TRAIT IEN_LIST
		SELECT 'UPDATE TRAIT_VALUE TABLE (IEN_LIST TRAIT) - PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		UPDATE TV
		SET [TRAIT_VALUE_STRING] = TV.TRAIT_VALUE_STRING + '|' + UPD_PATIENT.IEN_LIST
		FROM $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE AS TV
		INNER JOIN #UPDATE_PATIENT AS UPD_PATIENT ON TV.FK_ENTITY = UPD_PATIENT.DESTINATION_PK
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
		WHERE T.IDENTIFIER = 'IEN_LIST'

		--UPDATE UIDS
		SELECT 'UPDATE EHL7_UID TABLE - PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		UPDATE DESTINATION_UID
		SET IDENTIFIER_EXTENSION = SOURCE_UID.IDENTIFIER_EXTENSION
		FROM $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS DESTINATION_UID
		INNER JOIN #UPDATE_PATIENT AS UPD_PATIENT ON DESTINATION_UID.FK_ENTITY = UPD_PATIENT.DESTINATION_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS SOURCE_UID ON UPD_PATIENT.SOURCE_PK = SOURCE_UID.FK_ENTITY AND SOURCE_UID.IDENTIFIER_ROOT = DESTINATION_UID.IDENTIFIER_ROOT
		WHERE SOURCE_UID.IDENTIFIER_ROOT <> 'SSN'

		DROP TABLE #UPDATE_PATIENT

		-- *** INSERT PATIENT *** --
		SET @PK_ENTITY_TYPE = NULL
		SET @PK_ENTITY_TYPE_ON_DOMAIN=NULL
		SELECT @PK_ENTITY_TYPE = PK_ENTITY_TYPE FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE WHERE IDENTIFIER = 'HL7-RIM-V3-Person'

		SELECT @PK_ENTITY_TYPE_ON_DOMAIN = PK_ENTITY_TYPE_ON_DOMAIN
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE_ON_DOMAIN WHERE FK_DOMAIN = @PK_DOMAIN AND FK_ENTITY_TYPE = @PK_ENTITY_TYPE
		
		CREATE TABLE #CREATE_PATIENT(SOURCE_PK INT, IEN_LIST NVARCHAR(MAX))
		CREATE TABLE #PERSONS_IDS(DESTINATION_PK INT, SOURCE_PK INT, IEN_LIST NVARCHAR(MAX))
		SET @INDEX = 1
		
		WHILE (@INDEX <=@TOTAL_VISTA)
		BEGIN
			
			SELECT @VISTA_CODE = CODE FROM @IMPORT_VISTA WHERE ROW_NUM = @INDEX
			
			INSERT INTO #CREATE_PATIENT(SOURCE_PK, IEN_LIST)
			SELECT DISTINCT SOURCE_ENTITY.PK_ENTITY, TV.TRAIT_VALUE_STRING
			FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY 
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PATIENT_SSN ON ROLE_PATIENT.FK_PLAYER_ENTITY = PATIENT_SSN.FK_ENTITY AND PATIENT_SSN.IDENTIFIER_ROOT = 'SSN'
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = PATIENT_SSN.FK_ENTITY
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
			INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
			LEFT OUTER JOIN #CREATE_PATIENT AS PAT ON SOURCE_ENTITY.PK_ENTITY = PAT.SOURCE_PK
			WHERE PAT.SOURCE_PK IS NULL AND T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%' + @VISTA_CODE + '%' AND ROLE_PATIENT.CLASS_CODE = 'PAT' AND PATIENT_SSN.IDENTIFIER_EXTENSION NOT IN (
			SELECT P_SSN.IDENTIFIER_EXTENSION FROM $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS P_SSN
			INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE AS P_ROLE ON P_SSN.FK_ENTITY = P_ROLE.FK_PLAYER_ENTITY
			WHERE P_ROLE.CLASS_CODE = 'PAT' AND P_SSN.IDENTIFIER_ROOT = 'SSN' 
			) 

			SET @INDEX = @INDEX + 1
		END
		
		UPDATE UPD
			SET IEN_LIST = $(varSOURCE_BMS_EIS).dbo.fn_Get_Patient_Ien_List(UPD.IEN_LIST, @IMPORT_VISTA)
		FROM #CREATE_PATIENT AS UPD
		
		--INSERT PATIENT THAT IEN_LIS IS NULL
	    INSERT INTO #CREATE_PATIENT(SOURCE_PK, IEN_LIST)
		SELECT DISTINCT SOURCE_ENTITY.PK_ENTITY, TV.TRAIT_VALUE_STRING
		FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY 
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PATIENT_SSN ON ROLE_PATIENT.FK_PLAYER_ENTITY = PATIENT_SSN.FK_ENTITY AND PATIENT_SSN.IDENTIFIER_ROOT = 'SSN'
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV ON TV.FK_ENTITY = PATIENT_SSN.FK_ENTITY
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS TAET ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS T ON TAET.FK_TRAIT = T.PK_TRAIT
		LEFT OUTER JOIN #CREATE_PATIENT AS PAT ON SOURCE_ENTITY.PK_ENTITY = PAT.SOURCE_PK
		WHERE PAT.SOURCE_PK IS NULL AND T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING IS NULL AND ROLE_PATIENT.CLASS_CODE = 'PAT' AND PATIENT_SSN.IDENTIFIER_EXTENSION NOT IN (
		SELECT P_SSN.IDENTIFIER_EXTENSION FROM $(varDESTINATION_BMS_EIS).dbo.EHL7_UID AS P_SSN
		INNER JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE AS P_ROLE ON P_SSN.FK_ENTITY = P_ROLE.FK_PLAYER_ENTITY
		WHERE P_ROLE.CLASS_CODE = 'PAT' AND P_SSN.IDENTIFIER_ROOT = 'SSN' 
		) 
				
		--INSERT ENTITY
		SELECT 'INSERT INTO ENTITY TABLE - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY as DESTINATION_TABLE
		USING (SELECT DISTINCT SOURCE_ENTITY.*, NEW_PATIENT.IEN_LIST AS IEN_LIST
			FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY 
			INNER JOIN #CREATE_PATIENT AS NEW_PATIENT ON SOURCE_ENTITY.PK_ENTITY = NEW_PATIENT.SOURCE_PK
			)SOURCE_TABLE
		ON 0=1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES (SOURCE_TABLE.IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, SOURCE_TABLE.STATUS_CODE, SOURCE_TABLE.STATUS_CODE_SYSTEM,
				SOURCE_TABLE.STATUS_CODE_SYSTEM_NAME, SOURCE_TABLE.STATUS_DISPLAY_NAME, SOURCE_TABLE.LAST_MODIFICATION_TIME, SOURCE_TABLE.TRANSACTION_ID)
		OUTPUT INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY, SOURCE_TABLE.IEN_LIST INTO #PERSONS_IDS;
		
		DROP TABLE #CREATE_PATIENT
		
		--INSERT PATIENT
		SELECT 'INSERT INTO EHL7_PERSON TABLE - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_PERSON ([PFK_PERSON],[IDENTIFIER_ROOT] ,[IDENTIFIER_EXTENSION],[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME]
		,[CODE_DISPLAY_NAME],[DESCRIPTION],[ADMINISTRATIVE_GENDER_CODE],[ADMINISTRATIVE_GENDER_CODE_SYSTEM],[ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME]
		,[ADMINISTRATIVE_GENDER_DISPLAY_NAME],[BIRTH_TIME],[DECEASED_IND],[DECEASED_TIME],[MULTIPLE_BIRTH_IND],[MULTIPLE_BIRTH_ORDER_NUMBER]
		,[ORGAN_DONOR_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN],[NAME_PREFIX],[NAME_SUFFIX],[MARITAL_STATUS_CODE],[MARITAL_STATUS_CODE_SYSTEM]
		,[MARITAL_STATUS_CODE_SYSTEM_NAME],[MARITAL_STATUS_DISPLAY_NAME],[EDUCATION_LEVEL_CODE],[EDUCATION_LEVEL_CODE_SYSTEM],[EDUCATION_LEVEL_CODE_SYSTEM_NAME]
		,[EDUCATION_LEVEL_DISPLAY_NAME],[RACE_CODE],[RACE_CODE_SYSTEM],[RACE_CODE_SYSTEM_NAME],[RACE_DISPLAY_NAME],[DISABILITY_CODE],[DISABILITY_CODE_SYSTEM]
		,[DISABILITY_CODE_SYSTEM_NAME],[DISABILITY_DISPLAY_NAME],[LIVING_ARRANGEMENT_CODE],[LIVING_ARRANGEMENT_CODE_SYSTEM],[LIVING_ARRANGEMENT_CODE_SYSTEM_NAME]
		,[LIVING_ARRANGEMENT_DISPLAY_NAME],[RELIGIOUS_AFFILIATION_CODE],[RELIGIOUS_AFFILIATION_CODE_SYSTEM],[RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME]
		,[RELIGIOUS_AFFILIATION_DISPLAY_NAME],[ETHNIC_GROUP_CODE],[ETHNIC_GROUP_CODE_SYSTEM],[ETHNIC_GROUP_CODE_SYSTEM_NAME],[ETHNIC_GROUP_DISPLAY_NAME]
		,[EXISTENCE_TIME_LOW],[EXISTENCE_TIME_HIGH],[RISK_CODE],[RISK_CODE_SYSTEM],[RISK_CODE_SYSTEM_NAME],[RISK_DISPLAY_NAME],[HANDLING_CODE]
		,[HANDLING_CODE_SYSTEM],[HANDLING_CODE_SYSTEM_NAME],[HANDLING_DISPLAY_NAME])
		SELECT PATIENT.DESTINATION_PK, NULL, NULL, PERSON.CODE_CODE, PERSON.CODE_CODE_SYSTEM, PERSON.CODE_CODE_SYSTEM_NAME, PERSON.CODE_DISPLAY_NAME, PERSON.DESCRIPTION,
		PERSON.ADMINISTRATIVE_GENDER_CODE, PERSON.ADMINISTRATIVE_GENDER_CODE_SYSTEM, PERSON.ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME, PERSON.ADMINISTRATIVE_GENDER_DISPLAY_NAME,
		PERSON.BIRTH_TIME, PERSON.DECEASED_IND, PERSON.DECEASED_TIME, PERSON.MULTIPLE_BIRTH_IND, PERSON.MULTIPLE_BIRTH_ORDER_NUMBER, PERSON.ORGAN_DONOR_IND, PERSON.NAME_FAMILY,
		PERSON.NAME_FIRST_GIVEN, PERSON.NAME_SECOND_GIVEN, PERSON.NAME_PREFIX, PERSON.NAME_SUFFIX, PERSON.MARITAL_STATUS_CODE, PERSON.MARITAL_STATUS_CODE_SYSTEM,
		PERSON.MARITAL_STATUS_CODE_SYSTEM_NAME, PERSON.MARITAL_STATUS_DISPLAY_NAME, PERSON.EDUCATION_LEVEL_CODE, PERSON.EDUCATION_LEVEL_CODE_SYSTEM,
		PERSON.EDUCATION_LEVEL_CODE_SYSTEM_NAME, PERSON.EDUCATION_LEVEL_DISPLAY_NAME,PERSON.RACE_CODE, PERSON.RACE_CODE_SYSTEM, PERSON.RACE_CODE_SYSTEM_NAME,
		PERSON.RACE_DISPLAY_NAME, PERSON.DISABILITY_CODE, PERSON.DISABILITY_CODE_SYSTEM, PERSON.DISABILITY_CODE_SYSTEM_NAME,PERSON.DISABILITY_DISPLAY_NAME,
		PERSON.LIVING_ARRANGEMENT_CODE, PERSON.LIVING_ARRANGEMENT_CODE_SYSTEM, PERSON.LIVING_ARRANGEMENT_CODE_SYSTEM_NAME, PERSON.LIVING_ARRANGEMENT_DISPLAY_NAME,
		PERSON.RELIGIOUS_AFFILIATION_CODE, PERSON.RELIGIOUS_AFFILIATION_CODE_SYSTEM, PERSON.RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME, PERSON.RELIGIOUS_AFFILIATION_DISPLAY_NAME,
		PERSON.ETHNIC_GROUP_CODE, PERSON.ETHNIC_GROUP_CODE_SYSTEM, PERSON.ETHNIC_GROUP_CODE_SYSTEM_NAME, PERSON.ETHNIC_GROUP_DISPLAY_NAME,PERSON.EXISTENCE_TIME_LOW
		,PERSON.EXISTENCE_TIME_HIGH,PERSON.RISK_CODE, PERSON.RISK_CODE_SYSTEM,PERSON.RISK_CODE_SYSTEM_NAME,PERSON.RISK_DISPLAY_NAME,PERSON.HANDLING_CODE
		,PERSON.HANDLING_CODE_SYSTEM,PERSON.HANDLING_CODE_SYSTEM_NAME,PERSON.HANDLING_DISPLAY_NAME
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_PERSON AS PERSON
		INNER JOIN #PERSONS_IDS AS PATIENT ON PERSON.PFK_PERSON = PATIENT.SOURCE_PK

		--INSERT PATIENT UIDS
		SELECT 'INSERT INTO EHL7_UID TABLE - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_UID (FK_ENTITY,IDENTIFIER_ROOT,IDENTIFIER_EXTENSION)
		SELECT PATIENT.DESTINATION_PK, PERSON_UID.IDENTIFIER_ROOT, PERSON_UID.IDENTIFIER_EXTENSION 
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PERSON_UID
		INNER JOIN #PERSONS_IDS AS PATIENT ON PERSON_UID.FK_ENTITY = PATIENT.SOURCE_PK
		
		--INSERT TRAITS
		SELECT 'INSERT INTO TRAIT_VALUE TABLE (ALL TRAITS EXCEPT IEN_LIST TRAIT) - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE(FK_ENTITY, FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TRAIT_VALUE_STRING, 
			TRAIT_VALUE_REAL, TRAIT_VALUE_INTEGER, TRAIT_VALUE_DATETIME, TRAIT_VALUE_BYTE)
		SELECT UPD_PATIENT.DESTINATION_PK, SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, SOURCE_TV.TRAIT_VALUE_STRING, 
			SOURCE_TV.TRAIT_VALUE_REAL, SOURCE_TV.TRAIT_VALUE_INTEGER, SOURCE_TV.TRAIT_VALUE_DATETIME, SOURCE_TV.TRAIT_VALUE_BYTE 
		FROM $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS SOURCE_TV
		INNER JOIN #PERSONS_IDS AS UPD_PATIENT ON SOURCE_TV.FK_ENTITY = UPD_PATIENT.SOURCE_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS SOURCE_TAET ON SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = SOURCE_TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS SOURCE_T ON SOURCE_TAET.FK_TRAIT = SOURCE_T.PK_TRAIT
		WHERE SOURCE_T.IDENTIFIER <> 'IEN_LIST'

		--INSERT TRAIT IEN_LIST
		SELECT 'INSERT INTO TRAIT_VALUE TABLE (IEN_LIST TRAIT) - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE(FK_ENTITY, FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TRAIT_VALUE_STRING, 
			TRAIT_VALUE_REAL, TRAIT_VALUE_INTEGER, TRAIT_VALUE_DATETIME, TRAIT_VALUE_BYTE)
		SELECT UPD_PATIENT.DESTINATION_PK, SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, UPD_PATIENT.IEN_LIST, 
			SOURCE_TV.TRAIT_VALUE_REAL, SOURCE_TV.TRAIT_VALUE_INTEGER, SOURCE_TV.TRAIT_VALUE_DATETIME, SOURCE_TV.TRAIT_VALUE_BYTE 
		FROM $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS SOURCE_TV
		INNER JOIN #PERSONS_IDS AS UPD_PATIENT ON SOURCE_TV.FK_ENTITY = UPD_PATIENT.SOURCE_PK
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT_ASSIGNMENT_ENTITY_TYPE AS SOURCE_TAET ON SOURCE_TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = SOURCE_TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN $(varSOURCE_BMS_EIS).dbo.TRAIT AS SOURCE_T ON SOURCE_TAET.FK_TRAIT = SOURCE_T.PK_TRAIT
		WHERE SOURCE_T.IDENTIFIER = 'IEN_LIST'
			
		--INSERT ROLE
		SELECT 'INSERT INTO EHL7_ROLE TABLE - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])	  
		SELECT PATIENT.DESTINATION_PK, PATIENT_ROLE.FK_SCOPER_ENTITY, PATIENT_ROLE.CLASS_CODE, PATIENT_ROLE.CLASS_CODE_SYSTEM, 
			  PATIENT_ROLE.CLASS_CODE_SYSTEM_NAME, PATIENT_ROLE.CLASS_DISPLAY_NAME, PATIENT_ROLE.CODE_CODE, PATIENT_ROLE.CODE_CODE_SYSTEM, PATIENT_ROLE.CODE_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.CODE_DISPLAY_NAME, PATIENT_ROLE.NEGATION_IND, PATIENT_ROLE.NAME_FAMILY, PATIENT_ROLE.NAME_FIRST_GIVEN, PATIENT_ROLE.NAME_SECOND_GIVEN, 
			  PATIENT_ROLE.NAME_PREFIX, PATIENT_ROLE.NAME_SUFFIX, PATIENT_ROLE.STATUS_CODE, PATIENT_ROLE.STATUS_CODE_SYSTEM, PATIENT_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.STATUS_DISPLAY_NAME, PATIENT_ROLE.EFFECTIVE_TIME_LOW, PATIENT_ROLE.EFFECTIVE_TIME_HIGH, PATIENT_ROLE.CERTIFICATE_TEXT, 
			  PATIENT_ROLE.CONFIDENTIALITY_CODE, PATIENT_ROLE.CONFIDENTIALITY_CODE_SYSTEM, PATIENT_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.CONFIDENTIALITY_DISPLAY_NAME, PATIENT_ROLE.QUANTITY_NUMERATOR_VALUE, PATIENT_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  PATIENT_ROLE.QUANTITY_DENOMINATOR_VALUE, PATIENT_ROLE.QUANTITY_DENOMINATOR_UNIT, PATIENT_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS PATIENT_ROLE
		INNER JOIN #PERSONS_IDS AS PATIENT ON PATIENT_ROLE.FK_PLAYER_ENTITY = PATIENT.SOURCE_PK
		
		SELECT 'INSERT INTO [EHL7_ROLE_PATIENT] TABLE - NEW PATIENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.[EHL7_ROLE_PATIENT]
				   ([PK_PATIENT]
				   ,[VIP_CODE]
				   ,[VIP_CODE_SYSTEM]
				   ,[VIP_CODE_SYSTEM_NAME]
				   ,[VIP_DISPLAY_NAME])
		SELECT DISTINCT P_ROLE.PK_ROLE, NULL, NULL, NULL, NULL
		FROM $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE AS P_ROLE
		INNER JOIN #PERSONS_IDS AS PATIENT ON P_ROLE.FK_PLAYER_ENTITY = PATIENT.DESTINATION_PK	   
		
		-- *** INSERT PERSON *** ---
		DELETE FROM #PERSONS_IDS
		
		SET @PK_ENTITY_TYPE = NULL
		SET @PK_ENTITY_TYPE_ON_DOMAIN=NULL
		SELECT @PK_ENTITY_TYPE = PK_ENTITY_TYPE FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE WHERE IDENTIFIER = 'HL7-RIM-V3-Person'

		SELECT @PK_ENTITY_TYPE_ON_DOMAIN = PK_ENTITY_TYPE_ON_DOMAIN
		FROM $(varDESTINATION_BMS_EIS).dbo.ENTITY_TYPE_ON_DOMAIN WHERE FK_DOMAIN = @PK_DOMAIN AND FK_ENTITY_TYPE = @PK_ENTITY_TYPE;
		
		--INSERT ENTITY
		SELECT 'INSERT INTO ENTITY TABLE - MEDICAL STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;MERGE $(varDESTINATION_BMS_EIS).dbo.ENTITY as DESTINATION_TABLE
		USING (SELECT DISTINCT SOURCE_ENTITY.*
			   FROM $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_ENTITY 
			   INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS ROLE_PATIENT ON SOURCE_ENTITY.PK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY
			   INNER JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PERSON_UID ON PERSON_UID.FK_ENTITY = ROLE_PATIENT.FK_PLAYER_ENTITY AND PERSON_UID.IDENTIFIER_ROOT = 'SITE'
			   INNER JOIN #ORGANIZATIONS AS VISTA_SITE ON PERSON_UID.IDENTIFIER_EXTENSION = CAST(VISTA_SITE.SOURCE_ORGANIZATION_UID AS NVARCHAR(50))
			   WHERE ROLE_PATIENT.CLASS_CODE = 'PROV')SOURCE_TABLE
		ON 0=1
		WHEN NOT MATCHED THEN
		INSERT (IDENTIFIER, FK_ENTITY_TYPE_ON_DOMAIN, STATUS_CODE, STATUS_CODE_SYSTEM, 
				STATUS_CODE_SYSTEM_NAME, STATUS_DISPLAY_NAME, LAST_MODIFICATION_TIME, TRANSACTION_ID)
		VALUES (SOURCE_TABLE.IDENTIFIER, @PK_ENTITY_TYPE_ON_DOMAIN, SOURCE_TABLE.STATUS_CODE, SOURCE_TABLE.STATUS_CODE_SYSTEM,
				SOURCE_TABLE.STATUS_CODE_SYSTEM_NAME, SOURCE_TABLE.STATUS_DISPLAY_NAME, SOURCE_TABLE.LAST_MODIFICATION_TIME, SOURCE_TABLE.TRANSACTION_ID)
		OUTPUT INSERTED.PK_ENTITY, SOURCE_TABLE.PK_ENTITY INTO #PERSONS_IDS(DESTINATION_PK, SOURCE_PK);

		--INSERT PERSON
		SELECT 'INSERT INTO EHL7_PERSON TABLE - MEDICAL STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_PERSON ([PFK_PERSON],[IDENTIFIER_ROOT] ,[IDENTIFIER_EXTENSION],[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME]
		,[CODE_DISPLAY_NAME],[DESCRIPTION],[ADMINISTRATIVE_GENDER_CODE],[ADMINISTRATIVE_GENDER_CODE_SYSTEM],[ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME]
		,[ADMINISTRATIVE_GENDER_DISPLAY_NAME],[BIRTH_TIME],[DECEASED_IND],[DECEASED_TIME],[MULTIPLE_BIRTH_IND],[MULTIPLE_BIRTH_ORDER_NUMBER]
		,[ORGAN_DONOR_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN],[NAME_PREFIX],[NAME_SUFFIX],[MARITAL_STATUS_CODE],[MARITAL_STATUS_CODE_SYSTEM]
		,[MARITAL_STATUS_CODE_SYSTEM_NAME],[MARITAL_STATUS_DISPLAY_NAME],[EDUCATION_LEVEL_CODE],[EDUCATION_LEVEL_CODE_SYSTEM],[EDUCATION_LEVEL_CODE_SYSTEM_NAME]
		,[EDUCATION_LEVEL_DISPLAY_NAME],[RACE_CODE],[RACE_CODE_SYSTEM],[RACE_CODE_SYSTEM_NAME],[RACE_DISPLAY_NAME],[DISABILITY_CODE],[DISABILITY_CODE_SYSTEM]
		,[DISABILITY_CODE_SYSTEM_NAME],[DISABILITY_DISPLAY_NAME],[LIVING_ARRANGEMENT_CODE],[LIVING_ARRANGEMENT_CODE_SYSTEM],[LIVING_ARRANGEMENT_CODE_SYSTEM_NAME]
		,[LIVING_ARRANGEMENT_DISPLAY_NAME],[RELIGIOUS_AFFILIATION_CODE],[RELIGIOUS_AFFILIATION_CODE_SYSTEM],[RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME]
		,[RELIGIOUS_AFFILIATION_DISPLAY_NAME],[ETHNIC_GROUP_CODE],[ETHNIC_GROUP_CODE_SYSTEM],[ETHNIC_GROUP_CODE_SYSTEM_NAME],[ETHNIC_GROUP_DISPLAY_NAME]
		,[EXISTENCE_TIME_LOW],[EXISTENCE_TIME_HIGH],[RISK_CODE],[RISK_CODE_SYSTEM],[RISK_CODE_SYSTEM_NAME],[RISK_DISPLAY_NAME],[HANDLING_CODE]
		,[HANDLING_CODE_SYSTEM],[HANDLING_CODE_SYSTEM_NAME],[HANDLING_DISPLAY_NAME])
		SELECT PERS.DESTINATION_PK, NULL, NULL, PERSON.CODE_CODE, PERSON.CODE_CODE_SYSTEM, PERSON.CODE_CODE_SYSTEM_NAME, PERSON.CODE_DISPLAY_NAME, PERSON.DESCRIPTION,
		PERSON.ADMINISTRATIVE_GENDER_CODE, PERSON.ADMINISTRATIVE_GENDER_CODE_SYSTEM, PERSON.ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME, PERSON.ADMINISTRATIVE_GENDER_DISPLAY_NAME,
		PERSON.BIRTH_TIME, PERSON.DECEASED_IND, PERSON.DECEASED_TIME, PERSON.MULTIPLE_BIRTH_IND, PERSON.MULTIPLE_BIRTH_ORDER_NUMBER, PERSON.ORGAN_DONOR_IND, PERSON.NAME_FAMILY,
		PERSON.NAME_FIRST_GIVEN, PERSON.NAME_SECOND_GIVEN, PERSON.NAME_PREFIX, PERSON.NAME_SUFFIX, PERSON.MARITAL_STATUS_CODE, PERSON.MARITAL_STATUS_CODE_SYSTEM,
		PERSON.MARITAL_STATUS_CODE_SYSTEM_NAME, PERSON.MARITAL_STATUS_DISPLAY_NAME, PERSON.EDUCATION_LEVEL_CODE, PERSON.EDUCATION_LEVEL_CODE_SYSTEM,
		PERSON.EDUCATION_LEVEL_CODE_SYSTEM_NAME, PERSON.EDUCATION_LEVEL_DISPLAY_NAME,PERSON.RACE_CODE, PERSON.RACE_CODE_SYSTEM, PERSON.RACE_CODE_SYSTEM_NAME,
		PERSON.RACE_DISPLAY_NAME, PERSON.DISABILITY_CODE, PERSON.DISABILITY_CODE_SYSTEM, PERSON.DISABILITY_CODE_SYSTEM_NAME,PERSON.DISABILITY_DISPLAY_NAME,
		PERSON.LIVING_ARRANGEMENT_CODE, PERSON.LIVING_ARRANGEMENT_CODE_SYSTEM, PERSON.LIVING_ARRANGEMENT_CODE_SYSTEM_NAME, PERSON.LIVING_ARRANGEMENT_DISPLAY_NAME,
		PERSON.RELIGIOUS_AFFILIATION_CODE, PERSON.RELIGIOUS_AFFILIATION_CODE_SYSTEM, PERSON.RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME, PERSON.RELIGIOUS_AFFILIATION_DISPLAY_NAME,
		PERSON.ETHNIC_GROUP_CODE, PERSON.ETHNIC_GROUP_CODE_SYSTEM, PERSON.ETHNIC_GROUP_CODE_SYSTEM_NAME, PERSON.ETHNIC_GROUP_DISPLAY_NAME,PERSON.EXISTENCE_TIME_LOW
		,PERSON.EXISTENCE_TIME_HIGH,PERSON.RISK_CODE, PERSON.RISK_CODE_SYSTEM,PERSON.RISK_CODE_SYSTEM_NAME,PERSON.RISK_DISPLAY_NAME,PERSON.HANDLING_CODE
		,PERSON.HANDLING_CODE_SYSTEM,PERSON.HANDLING_CODE_SYSTEM_NAME,PERSON.HANDLING_DISPLAY_NAME
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_PERSON AS PERSON
		INNER JOIN #PERSONS_IDS AS PERS ON PERSON.PFK_PERSON = PERS.SOURCE_PK

		--INSERT PERSON UIDS
		SELECT 'INSERT INTO EHL7_UID TABLE - MEDICAL STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_UID (FK_ENTITY,IDENTIFIER_ROOT,IDENTIFIER_EXTENSION)
		SELECT PERS.DESTINATION_PK, PERSON_UID.IDENTIFIER_ROOT,
		CASE WHEN VISTA.DESTINATION_ORGANIZATION_UID IS NOT NULL THEN CAST(VISTA.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))
			 ELSE PERSON_UID.IDENTIFIER_EXTENSION 
		END  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_UID AS PERSON_UID
		INNER JOIN #PERSONS_IDS AS PERS ON PERSON_UID.FK_ENTITY = PERS.SOURCE_PK
		LEFT JOIN #ORGANIZATIONS AS VISTA ON CAST(VISTA.SOURCE_ORGANIZATION_UID AS NVARCHAR(50)) = PERSON_UID.IDENTIFIER_EXTENSION

		--INSERT PESRSON TRAITS
		SELECT 'INSERT INTO TRAIT_VALUE TABLE - MEDICAL STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.TRAIT_VALUE(FK_ENTITY, FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TRAIT_VALUE_STRING, 
			TRAIT_VALUE_REAL, TRAIT_VALUE_INTEGER, TRAIT_VALUE_DATETIME, TRAIT_VALUE_BYTE)
		SELECT PERS.DESTINATION_PK, TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE, TV.TRAIT_VALUE_STRING, 
			TV.TRAIT_VALUE_REAL, TV.TRAIT_VALUE_INTEGER, TV.TRAIT_VALUE_DATETIME, TV.TRAIT_VALUE_BYTE
		FROM $(varSOURCE_BMS_EIS).dbo.TRAIT_VALUE AS TV
		INNER JOIN #PERSONS_IDS AS PERS ON TV.FK_ENTITY = PERS.SOURCE_PK
		
		--INSERT ROLE
		SELECT 'INSERT INTO EHL7_ROLE TABLE - MEDICAL STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EIS).dbo.EHL7_ROLE ([FK_PLAYER_ENTITY],[FK_SCOPER_ENTITY],[CLASS_CODE],[CLASS_CODE_SYSTEM],[CLASS_CODE_SYSTEM_NAME],[CLASS_DISPLAY_NAME]
			  ,[CODE_CODE],[CODE_CODE_SYSTEM],[CODE_CODE_SYSTEM_NAME],[CODE_DISPLAY_NAME],[NEGATION_IND],[NAME_FAMILY],[NAME_FIRST_GIVEN],[NAME_SECOND_GIVEN]
			  ,[NAME_PREFIX],[NAME_SUFFIX],[STATUS_CODE],[STATUS_CODE_SYSTEM],[STATUS_CODE_SYSTEM_NAME],[STATUS_DISPLAY_NAME],[EFFECTIVE_TIME_LOW]
			  ,[EFFECTIVE_TIME_HIGH],[CERTIFICATE_TEXT],[CONFIDENTIALITY_CODE],[CONFIDENTIALITY_CODE_SYSTEM],[CONFIDENTIALITY_CODE_SYSTEM_NAME]
			  ,[CONFIDENTIALITY_DISPLAY_NAME],[QUANTITY_NUMERATOR_VALUE],[QUANTITY_NUMERATOR_UNIT],[QUANTITY_DENOMINATOR_VALUE]
			  ,[QUANTITY_DENOMINATOR_UNIT],[POSITION_NUMBER])
			  
		SELECT PATIENT.DESTINATION_PK, PATIENT_ROLE.FK_SCOPER_ENTITY, PATIENT_ROLE.CLASS_CODE, PATIENT_ROLE.CLASS_CODE_SYSTEM, 
			  PATIENT_ROLE.CLASS_CODE_SYSTEM_NAME, PATIENT_ROLE.CLASS_DISPLAY_NAME, PATIENT_ROLE.CODE_CODE, PATIENT_ROLE.CODE_CODE_SYSTEM, PATIENT_ROLE.CODE_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.CODE_DISPLAY_NAME, PATIENT_ROLE.NEGATION_IND, PATIENT_ROLE.NAME_FAMILY, PATIENT_ROLE.NAME_FIRST_GIVEN, PATIENT_ROLE.NAME_SECOND_GIVEN, 
			  PATIENT_ROLE.NAME_PREFIX, PATIENT_ROLE.NAME_SUFFIX, PATIENT_ROLE.STATUS_CODE, PATIENT_ROLE.STATUS_CODE_SYSTEM, PATIENT_ROLE.STATUS_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.STATUS_DISPLAY_NAME, PATIENT_ROLE.EFFECTIVE_TIME_LOW, PATIENT_ROLE.EFFECTIVE_TIME_HIGH, PATIENT_ROLE.CERTIFICATE_TEXT, 
			  PATIENT_ROLE.CONFIDENTIALITY_CODE, PATIENT_ROLE.CONFIDENTIALITY_CODE_SYSTEM, PATIENT_ROLE.CONFIDENTIALITY_CODE_SYSTEM_NAME, 
			  PATIENT_ROLE.CONFIDENTIALITY_DISPLAY_NAME, PATIENT_ROLE.QUANTITY_NUMERATOR_VALUE, PATIENT_ROLE.QUANTITY_NUMERATOR_UNIT, 				 
			  PATIENT_ROLE.QUANTITY_DENOMINATOR_VALUE, PATIENT_ROLE.QUANTITY_DENOMINATOR_UNIT, PATIENT_ROLE.POSITION_NUMBER		  
		FROM $(varSOURCE_BMS_EIS).dbo.EHL7_ROLE AS PATIENT_ROLE
		INNER JOIN #PERSONS_IDS AS PATIENT ON PATIENT_ROLE.FK_PLAYER_ENTITY = PATIENT.SOURCE_PK 
		
		DROP TABLE #PERSONS_IDS
		
		SELECT 'END IMPORT BMS_EIS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		SELECT 'START IMPORT BMS_EVS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		-- *** INSERT BMS EVS *** --
				
		CREATE TABLE #VOC_NESTED_VALUE_SET([increment] INT, [ranks] INT, [pk] INT, [uid] [varbinary](796), [valueSetID] [varchar](100), [conceptCode] [varchar](100), [nestedValueSetID] [varchar](100),
			 [isExpandable] [bit], [nodeType] [varchar](1), [level] [int], [isNestedRoot] [bit], [codingSchemeName] [varchar](70), [fk_code_reference] [int])

		SET @INDEX = 1
		WHILE (@INDEX <=@TOTAL_VISTA)
			BEGIN	
				
				SELECT @VISTA_CODE = CODE from @IMPORT_VISTA where ROW_NUM = @INDEX
				--INSERT CONCEPT
				SELECT 'INSERT concept TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
				INSERT INTO $(varDESTINATION_BMS_EVS).dbo.concept ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], 
					  [conceptStatus], [isAnonymous], [entityDescription]) 
				SELECT SOURCE_TABLE.codingSchemeName, SOURCE_TABLE.conceptCode, SOURCE_TABLE.firstVersion, SOURCE_TABLE.lastVersion, SOURCE_TABLE.isActive, 
					  SOURCE_TABLE.conceptStatus, SOURCE_TABLE.isAnonymous, SOURCE_TABLE.entityDescription
				FROM $(varSOURCE_BMS_EVS).dbo.concept AS SOURCE_TABLE
				WHERE SOURCE_TABLE.conceptCode like '%' + @VISTA_CODE +'%'
				
				--INSERT CONCEPT PROPERTT
				SELECT 'INSERT conceptProperty TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
				INSERT INTO $(varDESTINATION_BMS_EVS).dbo.conceptProperty([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui])
				SELECT SOURCE_TABLE.codingSchemeName, SOURCE_TABLE.conceptCode, SOURCE_TABLE.propertyId, SOURCE_TABLE.property, SOURCE_TABLE.[language], 
						SOURCE_TABLE.presentationFormat, SOURCE_TABLE.dataType, SOURCE_TABLE.isPreferred, SOURCE_TABLE.degreeOfFidelity, SOURCE_TABLE.matchIfNoContext, 
						SOURCE_TABLE.representationalForm, SOURCE_TABLE.propertyValue, SOURCE_TABLE.aui
				FROM $(varSOURCE_BMS_EVS).dbo.conceptProperty AS SOURCE_TABLE
				WHERE SOURCE_TABLE.conceptCode like '%' + @VISTA_CODE +'%'
				
				--INSERT VOC NESTED VALUE SET
				SELECT 'INSERT voc_nested_value_set TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
				
				DELETE FROM #VOC_NESTED_VALUE_SET
				
				;WITH CTE_COMMENT_VOC_NESTED_VALUE_SET AS
				(		
						SELECT SOURCE_TABLE.pk
						FROM $(varSOURCE_BMS_EVS).dbo.voc_nested_value_set AS SOURCE_TABLE
						INNER JOIN $(varDESTINATION_BMS_EVS).dbo.voc_nested_value_set AS DESTINATION_TABLE ON ISNULL(SOURCE_TABLE.conceptCode, 'NON_VALUE') = ISNULL(DESTINATION_TABLE.conceptCode, 'NON_VALUE') AND SOURCE_TABLE.codingSchemeName = DESTINATION_TABLE.codingSchemeName
				)
				
				INSERT INTO #VOC_NESTED_VALUE_SET([pk], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference])
				SELECT [pk], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]
				FROM $(varSOURCE_BMS_EVS).dbo.voc_nested_value_set 
				WHERE conceptCode like '%' + @VISTA_CODE +'%' and pk NOT IN (SELECT * FROM CTE_COMMENT_VOC_NESTED_VALUE_SET)

				;WITH CTE_RANK_VOC_NESTED_VALUE_SET AS
				(
						SELECT Rank() over (Partition by codingSchemeName Order by PK asc) as ranks, pk
						FROM #VOC_NESTED_VALUE_SET
				)

				UPDATE VOC
					SET ranks = RANKS.ranks
				FROM #VOC_NESTED_VALUE_SET AS VOC
				INNER JOIN CTE_RANK_VOC_NESTED_VALUE_SET AS RANKS ON VOC.pk = RANKS.pk

				UPDATE VOC
					SET increment = DESTINATION_TABLE.INCREMENT
				FROM #VOC_NESTED_VALUE_SET AS VOC
				INNER JOIN (select MAX(CAST([uid] AS INT)) AS INCREMENT, codingSchemeName
				FROM $(varDESTINATION_BMS_EVS).dbo.voc_nested_value_set
				GROUP BY codingSchemeName) AS DESTINATION_TABLE ON DESTINATION_TABLE.codingSchemeName = VOC.codingSchemeName

				UPDATE VOC
					SET increment = 0
				FROM #VOC_NESTED_VALUE_SET AS VOC
				WHERE increment IS NULL

				UPDATE VOC
					SET [UID] = (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(INCREMENT + RANKS as varbinary(8)))
				FROM #VOC_NESTED_VALUE_SET AS VOC

				INSERT INTO $(varDESTINATION_BMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) 
				SELECT [uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference] 
				FROM #VOC_NESTED_VALUE_SET
				
				SET @INDEX = @INDEX + 1
				
			END
		
		DELETE FROM #VOC_NESTED_VALUE_SET
		
		--INSERT CONCEPT
		SELECT 'INSERT concept TABLE (VistaSpecialty, Era)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		INSERT INTO $(varDESTINATION_BMS_EVS).dbo.concept ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], 
			  [conceptStatus], [isAnonymous], [entityDescription]) 
		SELECT SOURCE_TABLE.codingSchemeName, SOURCE_TABLE.conceptCode, SOURCE_TABLE.firstVersion, SOURCE_TABLE.lastVersion, SOURCE_TABLE.isActive, 
			  SOURCE_TABLE.conceptStatus, SOURCE_TABLE.isAnonymous, SOURCE_TABLE.entityDescription
		FROM $(varSOURCE_BMS_EVS).dbo.concept AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS_EVS).dbo.concept AS DESTINATION_TABLE ON SOURCE_TABLE.conceptCode = DESTINATION_TABLE.conceptCode AND SOURCE_TABLE.codingSchemeName = DESTINATION_TABLE.codingSchemeName
		WHERE DESTINATION_TABLE.conceptCode IS NULL AND SOURCE_TABLE.codingSchemeName IN ('VistaSpecialty', 'Era')

		--INSERT CONCEPT PROPERTT
		SELECT 'INSERT conceptProperty TABLE (VistaSpecialty, Era)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_EVS).dbo.conceptProperty([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui])
		SELECT SOURCE_TABLE.codingSchemeName, SOURCE_TABLE.conceptCode, SOURCE_TABLE.propertyId, SOURCE_TABLE.property, SOURCE_TABLE.[language], 
				SOURCE_TABLE.presentationFormat, SOURCE_TABLE.dataType, SOURCE_TABLE.isPreferred, SOURCE_TABLE.degreeOfFidelity, SOURCE_TABLE.matchIfNoContext, 
				SOURCE_TABLE.representationalForm, SOURCE_TABLE.propertyValue, SOURCE_TABLE.aui
		FROM $(varSOURCE_BMS_EVS).dbo.conceptProperty AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS_EVS).dbo.conceptProperty AS DESTINATION_TABLE ON SOURCE_TABLE.conceptCode = DESTINATION_TABLE.conceptCode AND SOURCE_TABLE.codingSchemeName = DESTINATION_TABLE.codingSchemeName
		WHERE DESTINATION_TABLE.conceptCode IS NULL AND SOURCE_TABLE.codingSchemeName IN ('VistaSpecialty', 'Era')

		--INSERT VOC NESTED VALUE SET
		SELECT 'INSERT voc_nested_value_set TABLE (VistaSpecialty, Era)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)

		;WITH CTE_COMMENT_VOC_NESTED_VALUE_SET AS
		(		
				SELECT SOURCE_TABLE.pk
				FROM $(varSOURCE_BMS_EVS).dbo.voc_nested_value_set AS SOURCE_TABLE
				INNER JOIN $(varDESTINATION_BMS_EVS).dbo.voc_nested_value_set AS DESTINATION_TABLE ON ISNULL(SOURCE_TABLE.conceptCode, 'NON_VALUE') = ISNULL(DESTINATION_TABLE.conceptCode, 'NON_VALUE') AND SOURCE_TABLE.codingSchemeName = DESTINATION_TABLE.codingSchemeName
				WHERE SOURCE_TABLE.codingSchemeName IN ('VistaSpecialty', 'Era')
		)

		INSERT INTO #VOC_NESTED_VALUE_SET([pk], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference])
		SELECT [pk], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]
		FROM $(varSOURCE_BMS_EVS).dbo.voc_nested_value_set 
		WHERE codingSchemeName IN ('VistaSpecialty', 'Era') AND pk NOT IN (SELECT * FROM CTE_COMMENT_VOC_NESTED_VALUE_SET) 

		;WITH CTE_RANK_VOC_NESTED_VALUE_SET AS
		(
				SELECT Rank() over (Partition by codingSchemeName Order by PK asc) as ranks, pk
				FROM #VOC_NESTED_VALUE_SET
		)

		UPDATE VOC
			SET ranks = RANKS.ranks
		FROM #VOC_NESTED_VALUE_SET AS VOC
		INNER JOIN CTE_RANK_VOC_NESTED_VALUE_SET AS RANKS ON VOC.pk = RANKS.pk

		UPDATE VOC
			SET increment = DESTINATION_TABLE.INCREMENT
		FROM #VOC_NESTED_VALUE_SET AS VOC
		INNER JOIN (select MAX(CAST([uid] AS INT)) AS INCREMENT, codingSchemeName
		FROM $(varDESTINATION_BMS_EVS).dbo.voc_nested_value_set
		GROUP BY codingSchemeName) AS DESTINATION_TABLE ON DESTINATION_TABLE.codingSchemeName = VOC.codingSchemeName

		UPDATE VOC
			SET increment = 0
		FROM #VOC_NESTED_VALUE_SET AS VOC
		WHERE increment IS NULL

		UPDATE VOC
			SET [UID] = (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(INCREMENT + RANKS as varbinary(8)))
		FROM #VOC_NESTED_VALUE_SET AS VOC

		INSERT INTO $(varDESTINATION_BMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) 
		SELECT [uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference] 
		FROM #VOC_NESTED_VALUE_SET

		DROP TABLE #VOC_NESTED_VALUE_SET
		
		SELECT 'END IMPORT BMS_EVS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		-- *** INSERT INTO BMS DATABASE *** --
		
		SELECT 'START IMPORT BMS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
				
		CREATE TABLE #MERGE_IDS(DESTINATION_ID INT, SOURCE_ID INT, ORDER_TYPE NVARCHAR(100))
		CREATE TABLE #SOURCE_CONFIG(ID INT, DOMAIN_ID NVARCHAR (50),[USER_NAME] NVARCHAR (MAX), DESTINATION_SECTION NVARCHAR (MAX),
							CONFIG_KEY NVARCHAR (MAX), CONFIG_VALUE NVARCHAR (MAX), CONFIG_TYPE NVARCHAR (10),
							VALUE_TYPE VARCHAR (MAX), FRIENDLY_NAME NVARCHAR (MAX), DESTINATION_ORGANIZATION_UID UNIQUEIDENTIFIER)
		
		SELECT 'INSERT INTO TEMPORARY TABLE SOURCE_CONFIG' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO #SOURCE_CONFIG(ID, DOMAIN_ID ,[USER_NAME], DESTINATION_SECTION,CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME, DESTINATION_ORGANIZATION_UID)
		SELECT SOURCE_C.ID, SOURCE_C.DOMAIN_ID, SOURCE_C.USER_NAME,
		REPLACE(SOURCE_C.SECTION, CAST(ORGANIZATION.SOURCE_ORGANIZATION_UID AS NVARCHAR(50)), CAST(ORGANIZATION.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))),
		REPLACE(SOURCE_C.CONFIG_KEY, CAST(ORGANIZATION.SOURCE_ORGANIZATION_UID AS NVARCHAR(50)), CAST(ORGANIZATION.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))),
		SOURCE_C.CONFIG_VALUE, SOURCE_C.CONFIG_TYPE, SOURCE_C.VALUE_TYPE, SOURCE_C.FRIENDLY_NAME, ORGANIZATION.DESTINATION_ORGANIZATION_UID
		FROM  $(varSOURCE_BMS).dbo.CONFIG AS SOURCE_C
		INNER JOIN #ORGANIZATIONS AS ORGANIZATION ON SOURCE_C.SECTION LIKE '%'+ CAST(ORGANIZATION.SOURCE_ORGANIZATION_UID AS NVARCHAR(50)) +'%'
		WHERE SOURCE_C.SECTION <> 'Sister Sites' AND SOURCE_C.SECTION <> 'MarqueeText'
		
		INSERT INTO #SOURCE_CONFIG(ID, DOMAIN_ID ,[USER_NAME], DESTINATION_SECTION,CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		SELECT C.ID, C.DOMAIN_ID ,C.[USER_NAME], C.SECTION, C.CONFIG_KEY,
		C.CONFIG_VALUE, C.CONFIG_TYPE, C.VALUE_TYPE, C.FRIENDLY_NAME
		FROM $(varSOURCE_BMS).dbo.CONFIG AS C
		INNER JOIN $(varSOURCE_BMS).dbo.CONFIG_EIS AS C_EIS ON C.ID = C_EIS.CONFIG_ID
		INNER JOIN #ORGANIZATIONS AS ORGANIZATION ON C_EIS.ENTITY_ID = ORGANIZATION.SOURCE_ORGANIZATION_UID
		WHERE C.SECTION='Profile' 
		
		INSERT INTO #SOURCE_CONFIG(ID, DOMAIN_ID ,[USER_NAME], DESTINATION_SECTION,CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		SELECT C.ID, C.DOMAIN_ID ,C.[USER_NAME], C.SECTION, 
		C.CONFIG_KEY, C.CONFIG_VALUE, C.CONFIG_TYPE, C.VALUE_TYPE, C.FRIENDLY_NAME
		FROM $(varSOURCE_BMS).dbo.CONFIG AS C
		WHERE C.SECTION LIKE '%JobCalendar%'
		
		SELECT 'DELETE FROM DESTINATION DATABASE CONFIG EVS TABLE IF SECTION ALREADY EXISTS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE EVS FROM $(varDESTINATION_BMS).dbo.CONFIG_EVS AS EVS
		INNER JOIN $(varDESTINATION_BMS).dbo.CONFIG AS OLD_CONFIG ON OLD_CONFIG.ID = EVS.CONFIG_ID
		INNER JOIN #SOURCE_CONFIG AS NEW_CONFIG ON NEW_CONFIG.DESTINATION_SECTION = OLD_CONFIG.SECTION 
		
		SELECT 'DELETE FROM DESTINATION DATABASE CONFIG EIS TABLE IF SECTION ALREADY EXISTS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE EIS FROM $(varDESTINATION_BMS).dbo.CONFIG_EIS AS EIS
		INNER JOIN $(varDESTINATION_BMS).dbo.CONFIG AS OLD_CONFIG ON OLD_CONFIG.ID = EIS.CONFIG_ID
		INNER JOIN #SOURCE_CONFIG AS NEW_CONFIG ON NEW_CONFIG.DESTINATION_SECTION = OLD_CONFIG.SECTION 
		WHERE NEW_CONFIG.DESTINATION_SECTION <> 'Profile'
		
		SELECT 'DELETE FROM DESTINATION DATABASE CONFIG TABLE IF SECTION ALREADY EXISTS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE OLD_CONFIG FROM $(varDESTINATION_BMS).dbo.CONFIG AS OLD_CONFIG 
		INNER JOIN #SOURCE_CONFIG AS NEW_CONFIG ON NEW_CONFIG.DESTINATION_SECTION = OLD_CONFIG.SECTION
		WHERE NEW_CONFIG.DESTINATION_SECTION <> 'Profile'
		
		SELECT 'DELETE FROM DESTINATION DATABASE CONFIG EIS TABLE IF USER PROFILE ALREADY EXISTS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE EIS FROM $(varDESTINATION_BMS).dbo.CONFIG_EIS AS EIS
		INNER JOIN $(varDESTINATION_BMS).dbo.CONFIG AS OLD_CONFIG ON OLD_CONFIG.ID = EIS.CONFIG_ID
		INNER JOIN #SOURCE_CONFIG AS NEW_CONFIG ON NEW_CONFIG.DESTINATION_SECTION = OLD_CONFIG.SECTION AND NEW_CONFIG.[USER_NAME] = OLD_CONFIG.[USER_NAME]
		WHERE NEW_CONFIG.DESTINATION_SECTION = 'Profile'
		
		SELECT 'DELETE FROM DESTINATION DATABASE CONFIG TABLE IF USER PROFILE ALREADY EXISTS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE OLD_CONFIG FROM $(varDESTINATION_BMS).dbo.CONFIG AS OLD_CONFIG 
		INNER JOIN #SOURCE_CONFIG AS NEW_CONFIG ON NEW_CONFIG.DESTINATION_SECTION = OLD_CONFIG.SECTION AND NEW_CONFIG.[USER_NAME] = OLD_CONFIG.[USER_NAME]
		WHERE NEW_CONFIG.DESTINATION_SECTION = 'Profile'
			
		SELECT 'INSERT INTO BMS CONFIG TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		--COPY INTO DESTINATION CONFIG TABLE
		INSERT INTO $(varDESTINATION_BMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		SELECT DOMAIN_ID, USER_NAME, DESTINATION_SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME
		FROM #SOURCE_CONFIG
		WHERE CONFIG_KEY <> 'IntegratedSiteSisterConfigKey'
		
		--COPY INTO DESTINATION CONFIG_EVS TABLE
		SELECT 'INSERT INTO BMS CONFIG_EVS TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONFIG_EVS(CONFIG_ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT DISTINCT DESTINATION_TABLE.ID, SOURCE_CONFIG_EVS.CODE, SOURCE_CONFIG_EVS.CODE_SYSTEM, SOURCE_CONFIG_EVS.CODE_SYSTEM_NAME, SOURCE_CONFIG_EVS.DISPLAY_NAME
		FROM $(varDESTINATION_BMS).dbo.CONFIG AS DESTINATION_TABLE
		INNER JOIN #SOURCE_CONFIG AS SOURCE_TABLE ON DESTINATION_TABLE.SECTION = SOURCE_TABLE.DESTINATION_SECTION AND DESTINATION_TABLE.CONFIG_KEY = SOURCE_TABLE.CONFIG_KEY
		INNER JOIN  $(varSOURCE_BMS).dbo.CONFIG_EVS AS SOURCE_CONFIG_EVS ON SOURCE_TABLE.ID = SOURCE_CONFIG_EVS.CONFIG_ID
		WHERE SOURCE_TABLE.VALUE_TYPE = 'EVS'

		--COPY INTO DESTINATION CONFIG_EIS TABLE
		SELECT 'INSERT INTO BMS CONFIG_EIS TABLE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)	
		INSERT INTO $(varDESTINATION_BMS).dbo.CONFIG_EIS(CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID)
		SELECT DISTINCT DESTINATION_TABLE.ID, ORGANIZATION.DESTINATION_ORGANIZATION_UID, SOURCE_CONFIG_EIS.ENTITY_NAME, SOURCE_CONFIG_EIS.ENTITY_TYPE_ID
		FROM $(varDESTINATION_BMS).dbo.CONFIG AS DESTINATION_TABLE
		INNER JOIN #SOURCE_CONFIG AS SOURCE_TABLE ON ISNULL(SOURCE_TABLE.USER_NAME, 'NON_VALUE') = ISNULL(DESTINATION_TABLE.USER_NAME, 'NON_VALUE')  
			AND DESTINATION_TABLE.SECTION = SOURCE_TABLE.DESTINATION_SECTION AND DESTINATION_TABLE.CONFIG_KEY = SOURCE_TABLE.CONFIG_KEY
		INNER JOIN $(varSOURCE_BMS).dbo.CONFIG_EIS AS SOURCE_CONFIG_EIS ON SOURCE_TABLE.ID = SOURCE_CONFIG_EIS.CONFIG_ID
		INNER JOIN #ORGANIZATIONS AS ORGANIZATION ON ORGANIZATION.SOURCE_ORGANIZATION_UID = SOURCE_CONFIG_EIS.ENTITY_ID
		WHERE SOURCE_TABLE.VALUE_TYPE = 'EIS'

		SELECT 'INSERT INTO BMS CONFIG TABLE (IntegratedSiteSisterConfigKey)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
		SELECT SOURCE_TABLE.DOMAIN_ID, SOURCE_TABLE.USER_NAME, SOURCE_TABLE.DESTINATION_SECTION, SOURCE_TABLE.CONFIG_KEY,
		(SELECT TOP 1 CONFIG_KEY FROM $(varDESTINATION_BMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(SOURCE_TABLE.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))+'%'),
		SOURCE_TABLE.CONFIG_TYPE, SOURCE_TABLE.VALUE_TYPE, SOURCE_TABLE.FRIENDLY_NAME
		FROM #SOURCE_CONFIG AS SOURCE_TABLE
		WHERE SOURCE_TABLE.CONFIG_KEY = 'IntegratedSiteSisterConfigKey'
		AND (SELECT COUNT(CONFIG_KEY) FROM $(varDESTINATION_BMS).dbo.CONFIG WHERE SECTION='Sister Sites' AND CONFIG_VALUE LIKE '%'+CAST(SOURCE_TABLE.DESTINATION_ORGANIZATION_UID AS NVARCHAR(50))+'%') > 0

		DROP TABLE #SOURCE_CONFIG
		
		-- *** INSERT INTO CONCEPT *** --
		SELECT 'INSERT INTO BMS CONCEPT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.CODE_SYSTEM_NAME IN ('VistaSpecialty', 'Era')
		
		SET @INDEX = 1
		WHILE (@INDEX <=@TOTAL_VISTA)
			BEGIN	
				
				SELECT @VISTA_CODE = CODE from @IMPORT_VISTA where ROW_NUM = @INDEX
				
				INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
				SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
				FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
				WHERE SOURCE_TABLE.CODE LIKE '%'+ @VISTA_CODE +'%'
				
				SET @INDEX = @INDEX + 1
				
			END
	
		-- *** INSERT DISCHARGE APPOINTMENT CLINICS *** --
		SELECT 'INSERT INTO BMS DISCHARGE APPOINTMENT CLINICS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.HOSPITAL_LOCATION_APPOINTMENT(DOMAIN_ID, HOSPITAL_LOCATION_UID, FACILITY_UID, VISTA_SITE_UID)
		SELECT DISTINCT SOURCE_HLA.DOMAIN_ID, SOURCE_HLA.HOSPITAL_LOCATION_UID, FACILITY.DESTINATION_ORGANIZATION_UID, VISTA.DESTINATION_ORGANIZATION_UID
		FROM  $(varSOURCE_BMS).dbo.HOSPITAL_LOCATION_APPOINTMENT AS SOURCE_HLA
		INNER JOIN #ORGANIZATIONS AS FACILITY ON SOURCE_HLA.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN #ORGANIZATIONS AS VISTA ON SOURCE_HLA.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		
		-- *** INSERT DIVERSION *** --
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT LOCATION_ID FROM $(varSOURCE_BMS).dbo.DIVERSION )

		SELECT 'INSERT INTO BMS DIVERSION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.DIVERSION(FACILITY_UID, VISTA_SITE_UID, ACTIVE, [START_DATE], END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, 
		ENTERED_DATE, LAST_EDIT_BY)
		SELECT FACILITY.DESTINATION_ORGANIZATION_UID, VISTA.DESTINATION_ORGANIZATION_UID, DIVERSION.ACTIVE, DIVERSION.[START_DATE], DIVERSION.END_DATE, 
		DESTINATION_TABLE.ID, DIVERSION.DOMAIN_ID, DIVERSION.COMMENTS, DIVERSION.ENTERED_BY, DIVERSION.ENTERED_DATE, DIVERSION.LAST_EDIT_BY 
		FROM $(varSOURCE_BMS).dbo.DIVERSION AS DIVERSION
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE ON DIVERSION.LOCATION_ID = SOURCE_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		INNER JOIN #ORGANIZATIONS AS FACILITY ON DIVERSION.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		LEFT JOIN #ORGANIZATIONS AS VISTA ON DIVERSION.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID;

		-- *** INSERT BED_UNAVAILABLE *** --	
		--INSERT ACT
		SELECT 'INSERT INTO BMS ACT - BED UNAVA.' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ACT(PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN) 
		SELECT A.PATIENT_UID, A.CREATION_DATE, A.CANCELED_DATE, A.PARENT_ACT_ID, A.FLOW_ID, A.DOMAIN_ID, IEN
		FROM $(varSOURCE_BMS).dbo.ACT AS A
		INNER JOIN $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS BU ON A.ID = BU.ACT_ID
		INNER JOIN #ORGANIZATIONS AS VISTA ON BU.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		   
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID)
		SELECT DESTINATION_A.ID, SOURCE_A.ID
		FROM $(varSOURCE_BMS).dbo.ACT AS SOURCE_A
		INNER JOIN $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS SOURCE_BU ON SOURCE_A.ID = SOURCE_BU.ACT_ID
		INNER JOIN $(varDESTINATION_BMS).dbo.ACT AS DESTINATION_A ON SOURCE_A.FLOW_ID = DESTINATION_A.FLOW_ID
		INNER JOIN #ORGANIZATIONS AS VISTA ON SOURCE_BU.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		

		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT [TYPE_ID] 
																	 FROM $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS BU
																	 INNER JOIN #MERGE_IDS AS ACT ON BU.ACT_ID = ACT.SOURCE_ID
																	 WHERE [TYPE_ID] IS NOT NULL)
																	 
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT REASON_ID 
																	 FROM $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS BU
																	 INNER JOIN #MERGE_IDS AS ACT ON BU.ACT_ID = ACT.SOURCE_ID
																	 WHERE REASON_ID IS NOT NULL)																 
		
		--INSERT BED_UNAVAILABLE TABLE
		SELECT 'INSERT INTO BMS BED UNAVA.' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_UNAVAILABLE(ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, CREATIONBY, EDITEDBY, EDITED_DATE, COMPLETEDBY,
		COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
		SELECT ACT.DESTINATION_ID, BU.DIVISION_UID, BU.BED_UID, DESTINATION_TYPE_TABLE.ID, DESTINATION_REASON_TABLE.ID, BU.CREATIONBY, BU.EDITEDBY, BU.EDITED_DATE, BU.COMPLETEDBY,
		BU.COMPLETED_DATE, VISTA.DESTINATION_ORGANIZATION_UID, BU.IS_UNAVAILABLE_FROM_VISTA, BU.EXPECTED_COMPLETED_DATE
		FROM $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS BU
		INNER JOIN #MERGE_IDS AS ACT ON BU.ACT_ID = ACT.SOURCE_ID
		INNER JOIN #ORGANIZATIONS AS VISTA ON BU.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TYPE_TABLE ON BU.TYPE_ID = SOURCE_TYPE_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TYPE_TABLE ON SOURCE_TYPE_TABLE.CODE = DESTINATION_TYPE_TABLE.CODE
																	 AND SOURCE_TYPE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TYPE_TABLE.CODE_SYSTEM_NAME
		
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_REASON_TABLE ON BU.REASON_ID = SOURCE_REASON_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_REASON_TABLE ON SOURCE_REASON_TABLE.CODE = DESTINATION_REASON_TABLE.CODE 
																	AND SOURCE_REASON_TABLE.CODE_SYSTEM_NAME = DESTINATION_REASON_TABLE.CODE_SYSTEM_NAME

		--INSERT INTO BED UNAVAILABLE WARD
		SELECT 'INSERT INTO BMS BED UNAVA. WARD' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_UNAVAILABLE_WARD(BED_UNAVAILABLE_ID, WARD_UID)
		SELECT ACT.DESTINATION_ID, WARD_UID
		FROM  $(varSOURCE_BMS).dbo.BED_UNAVAILABLE_WARD AS BU
		INNER JOIN #MERGE_IDS AS ACT ON BU.BED_UNAVAILABLE_ID = ACT.SOURCE_ID

		-- *** INSERT BED STAFF *** --
		SELECT 'INSERT INTO BMS BED STAFF' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_STAFF(BED_UID, DIVISION_UID, STAFF, PATIENT_UID, FACILITY_UID)
		SELECT STAFF.BED_UID, STAFF.DIVISION_UID, STAFF.STAFF, STAFF.PATIENT_UID, FACILITY.DESTINATION_ORGANIZATION_UID
		FROM  $(varSOURCE_BMS).dbo.BED_STAFF AS STAFF
		INNER JOIN #ORGANIZATIONS AS FACILITY ON STAFF.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID

		-- *** INSERT INTO BED UNAVAILABLE HISTORY *** --
		SELECT 'INSERT INTO BMS BED UNAVAILABLE HISTORY' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_REASON_COMMENT_HISTORY
		(
		DIVISION_UID,
		BED_UID,
		VISTA_SITE_UID,
		TYPE_ID,
		REASON_ID,
		COMMENT,
		CREATIONBY,
		CREATION_DATE,
		EDITEDBY,
		EDITED_DATE,
		COMPLETEDBY,
		COMPLETED_DATE, 
		EXPECTED_COMPLETED_DATE
		)
		SELECT BU.DIVISION_UID, BU.BED_UID, VISTA.DESTINATION_ORGANIZATION_UID, DESTINATION_TYPE_TABLE.ID, DESTINATION_REASON_TABLE.ID,
		BU.COMMENT, BU.CREATIONBY, BU.CREATION_DATE, BU.EDITEDBY, BU.EDITED_DATE, BU.COMPLETEDBY, BU.COMPLETED_DATE, 
		BU.EXPECTED_COMPLETED_DATE 
		FROM  $(varSOURCE_BMS).dbO.BED_REASON_COMMENT_HISTORY AS BU 
		INNER JOIN #ORGANIZATIONS AS VISTA ON BU.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TYPE_TABLE ON BU.TYPE_ID = SOURCE_TYPE_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TYPE_TABLE ON SOURCE_TYPE_TABLE.CODE = DESTINATION_TYPE_TABLE.CODE 
																  AND SOURCE_TYPE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TYPE_TABLE.CODE_SYSTEM_NAME
		
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_REASON_TABLE ON BU.REASON_ID = SOURCE_REASON_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_REASON_TABLE ON SOURCE_REASON_TABLE.CODE = DESTINATION_REASON_TABLE.CODE
																	AND SOURCE_REASON_TABLE.CODE_SYSTEM_NAME = DESTINATION_REASON_TABLE.CODE_SYSTEM_NAME
		
		-- *** INSERT VISN WAITING LIST *** --
		--INSERT ACT
		SELECT 'INSERT INTO BMS ACT - VISN WAITING LIST(REQ)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DELETE FROM #MERGE_IDS
		INSERT INTO $(varDESTINATION_BMS).dbo.ACT(PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN) 
		SELECT A.PATIENT_UID, A.CREATION_DATE, A.CANCELED_DATE, A.PARENT_ACT_ID, A.FLOW_ID, A.DOMAIN_ID, IEN
		FROM $(varSOURCE_BMS).dbo.ACT AS A
		INNER JOIN $(varSOURCE_BMS).dbo.TRANSFER_REQ AS REQ ON A.ID = REQ.ACT_ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON REQ.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		   
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID)
		SELECT DESTINATION_A.ID, SOURCE_A.ID
		FROM $(varSOURCE_BMS).dbo.ACT AS SOURCE_A
		INNER JOIN $(varSOURCE_BMS).dbo.TRANSFER_REQ AS REQ ON SOURCE_A.ID = REQ.ACT_ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON REQ.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN $(varDESTINATION_BMS).dbo.ACT AS DESTINATION_A ON SOURCE_A.FLOW_ID = DESTINATION_A.FLOW_ID 
		
		SELECT 'INSERT INTO BMS ACT - VISN WAITING LIST(EVN)' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ACT(PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN) 
		SELECT A.PATIENT_UID, A.CREATION_DATE, A.CANCELED_DATE, PARENT_ACT.DESTINATION_ID, A.FLOW_ID, A.DOMAIN_ID, IEN
		FROM $(varSOURCE_BMS).dbo.ACT AS A
		INNER JOIN $(varSOURCE_BMS).dbo.TRANSFER_EVN AS EVN ON A.ID = EVN.ACT_ID
		INNER JOIN #MERGE_IDS AS PARENT_ACT ON A.PARENT_ACT_ID = PARENT_ACT.SOURCE_ID	
		   
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID)
		SELECT DESTINATION_A.ID, SOURCE_A.ID
		FROM $(varSOURCE_BMS).dbo.ACT AS SOURCE_A
		INNER JOIN $(varSOURCE_BMS).dbo.TRANSFER_EVN AS EVN ON SOURCE_A.ID = EVN.ACT_ID
		INNER JOIN #MERGE_IDS AS PARENT_ACT ON SOURCE_A.PARENT_ACT_ID = PARENT_ACT.SOURCE_ID
		INNER JOIN $(varDESTINATION_BMS).dbO.ACT AS DESTINATION_A ON PARENT_ACT.DESTINATION_ID = DESTINATION_A.PARENT_ACT_ID
		WHERE SOURCE_A.PARENT_ACT_ID IS NOT NULL
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT CONTRACT_ID 
																	 FROM $(varSOURCE_BMS).dbo.TRANSFER_REQ AS REQ
																	 INNER JOIN #MERGE_IDS AS ACT ON REQ.ACT_ID = ACT.SOURCE_ID
																	 WHERE CONTRACT_ID IS NOT NULL)	
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT SPECIALITY_ID 
																	 FROM $(varSOURCE_BMS).dbo.TRANSFER_REQ AS REQ
																	 INNER JOIN #MERGE_IDS AS ACT ON REQ.ACT_ID = ACT.SOURCE_ID
																	 WHERE SPECIALITY_ID IS NOT NULL)
																	 
		--INSERT INTO TRANSFER REQ
		SELECT 'INSERT INTO BMS TRANSFER REQ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.TRANSFER_REQ
			(
				ACT_ID,
				ERA_ID,
				FACILITY_UID,
				VISTA_SITE_UID,
				CONTRACT_ID,
				SPECIALITY_ID,
				DIAGNOSIS,
				CURRENT_LOCATION,
				COMMENTS,
				LOCATION_ADMISSION_DATE,
				FACILITY_REGION,
				FACILITY_VISN,
				REQUESTED_DATE,
				ENTERED_BY,
				LAST_EDIT_BY,
				EDITED,
				IS_NATIONAL_WAIT_LIST
			)
		SELECT ACT.DESTINATION_ID, DESTINATION_REQ_ERA_TABLE.ID, FACILITY.DESTINATION_ORGANIZATION_UID, VISTA.DESTINATION_ORGANIZATION_UID,
		  DESTINATION_REQ_CONTRACT_TABLE.ID, DESTINATION_REQ_SPECIALITY_TABLE.ID, REQ.DIAGNOSIS, REQ.CURRENT_LOCATION, REQ.COMMENTS,
		  REQ.LOCATION_ADMISSION_DATE, REQ.FACILITY_REGION, REQ.FACILITY_VISN, REQ.REQUESTED_DATE,
		  REQ.ENTERED_BY, REQ.LAST_EDIT_BY, REQ.EDITED, REQ.IS_NATIONAL_WAIT_LIST 
		FROM $(varSOURCE_BMS).dbo.TRANSFER_REQ AS REQ
		INNER JOIN #MERGE_IDS AS ACT ON REQ.ACT_ID = ACT.SOURCE_ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON REQ.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN #ORGANIZATIONS AS VISTA ON REQ.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_REQ_CONTRACT_TABLE ON REQ.CONTRACT_ID = SOURCE_REQ_CONTRACT_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_REQ_CONTRACT_TABLE ON SOURCE_REQ_CONTRACT_TABLE.CODE = DESTINATION_REQ_CONTRACT_TABLE.CODE AND SOURCE_REQ_CONTRACT_TABLE.CODE_SYSTEM_NAME = DESTINATION_REQ_CONTRACT_TABLE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_REQ_ERA_TABLE ON REQ.ERA_ID = SOURCE_REQ_ERA_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_REQ_ERA_TABLE ON SOURCE_REQ_ERA_TABLE.CODE = DESTINATION_REQ_ERA_TABLE.CODE AND SOURCE_REQ_ERA_TABLE.CODE_SYSTEM_NAME = DESTINATION_REQ_ERA_TABLE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_REQ_SPECIALITY_TABLE ON REQ.SPECIALITY_ID = SOURCE_REQ_SPECIALITY_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_REQ_SPECIALITY_TABLE ON SOURCE_REQ_SPECIALITY_TABLE.CODE = DESTINATION_REQ_SPECIALITY_TABLE.CODE AND SOURCE_REQ_SPECIALITY_TABLE.CODE_SYSTEM_NAME = DESTINATION_REQ_SPECIALITY_TABLE.CODE_SYSTEM_NAME

		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT DISPOSITION_ID 
																	 FROM $(varSOURCE_BMS).dbo.TRANSFER_EVN AS EVN
																	 INNER JOIN #MERGE_IDS AS ACT ON EVN.ACT_ID = ACT.SOURCE_ID
																	 WHERE DISPOSITION_ID IS NOT NULL)
		
		--INSERT INTO TRANSFER EVN
		SELECT 'INSERT INTO BMS TRANSFER EVN' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.TRANSFER_EVN(ACT_ID, COMMENT, ADMISSION_FACILITY_UID, DISPOSITION_ID, DISPOSITION_DATE)
		SELECT ACT.DESTINATION_ID, EVN.COMMENT, DESTINATION_E.IDENTIFIER, DESTINATION_DISPOSITION_TABLE.ID, EVN.DISPOSITION_DATE 
		FROM  $(varSOURCE_BMS).dbo.TRANSFER_EVN AS EVN
		INNER JOIN #MERGE_IDS AS ACT ON EVN.ACT_ID = ACT.SOURCE_ID
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.ENTITY AS SOURCE_E ON SOURCE_E.IDENTIFIER = EVN.ADMISSION_FACILITY_UID
		LEFT JOIN $(varSOURCE_BMS_EIS).dbo.EHL7_ORGANIZATION AS SOURCE_ORG ON SOURCE_ORG.PFK_ORGANIZATION = SOURCE_E.PK_ENTITY
		LEFT JOIN $(varDESTINATION_BMS_EIS).dbo.EHL7_ORGANIZATION AS DESTINATION_ORG ON SOURCE_ORG.NAME = DESTINATION_ORG.NAME AND SOURCE_ORG.CODE_CODE = DESTINATION_ORG.CODE_CODE
		LEFT JOIN $(varDESTINATION_BMS_EIS).dbo.ENTITY AS DESTINATION_E ON DESTINATION_ORG.PFK_ORGANIZATION = DESTINATION_E.PK_ENTITY
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_DISPOSITION_TABLE ON EVN.DISPOSITION_ID = SOURCE_DISPOSITION_TABLE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_DISPOSITION_TABLE ON SOURCE_DISPOSITION_TABLE.CODE = DESTINATION_DISPOSITION_TABLE.CODE AND SOURCE_DISPOSITION_TABLE.CODE_SYSTEM_NAME = DESTINATION_DISPOSITION_TABLE.CODE_SYSTEM_NAME
		
		-- *** INSERT FACILITY WAITING LIST *** --
		--INSERT ACT
		SELECT 'INSERT INTO BMS ACT - FACILITY WAITING LIST' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)		
		INSERT INTO $(varDESTINATION_BMS).dbo.ACT(PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN) 
		SELECT A.PATIENT_UID, A.CREATION_DATE, A.CANCELED_DATE, PARENT_ACT.DESTINATION_ID, A.FLOW_ID, A.DOMAIN_ID, IEN
		FROM $(varSOURCE_BMS).dbo.ACT AS A
		INNER JOIN $(varSOURCE_BMS).dbo.WAITING_LIST AS WL ON A.ID = WL.ACT_ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON WL.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		LEFT JOIN #MERGE_IDS AS PARENT_ACT ON A.PARENT_ACT_ID = PARENT_ACT.SOURCE_ID
		
		DELETE FROM #MERGE_IDS   
		
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID)
		SELECT DESTINATION_A.ID, SOURCE_A.ID
		FROM $(varSOURCE_BMS).dbo.ACT AS SOURCE_A
		INNER JOIN $(varSOURCE_BMS).dbo.WAITING_LIST AS SOURCE_WL ON SOURCE_A.ID = SOURCE_WL.ACT_ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON SOURCE_WL.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN $(varDESTINATION_BMS).dbo.ACT AS DESTINATION_A ON SOURCE_A.FLOW_ID = DESTINATION_A.FLOW_ID AND DESTINATION_A.CREATION_DATE = SOURCE_A.CREATION_DATE
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.WAITING_AREA_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.WAITING_AREA_ID IS NOT NULL)		
																	 
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.FEE_DISPOSITION_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.FEE_DISPOSITION_ID IS NOT NULL)																	 
																	 
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.CONTRACT_FEE_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.CONTRACT_FEE_ID IS NOT NULL)		
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.AUTHORIZED_FEE_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.AUTHORIZED_FEE_ID IS NOT NULL)				
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT SERVICE_RECEIVING_FEE_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.SERVICE_RECEIVING_FEE_ID IS NOT NULL)		
																	 		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.REASON_USING_FEE_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.REASON_USING_FEE_ID IS NOT NULL)	
																	 		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.EVACUATION_DISPOSITION_STATUS_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.EVACUATION_DISPOSITION_STATUS_ID IS NOT NULL)
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.EVACUATION_TRANSPORTATION_TYPE_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.EVACUATION_TRANSPORTATION_TYPE_ID IS NOT NULL)

		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT WL.EVACUATION_TRANSPORTATION_PROVIDER_ID 
																	 FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
																	 INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
																	 WHERE WL.EVACUATION_TRANSPORTATION_PROVIDER_ID IS NOT NULL)																		 
																	 		
		--INSERT INTO WAITING LIST TABLE
		SELECT 'INSERT INTO BMS FACILITY WAITING LIST' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)	
		INSERT INTO $(varDESTINATION_BMS).dbo.WAITING_LIST
		(
		ACT_ID, 
		FACILITY_UID, 
		WAITING_AREA_ID, 
		PROBLEM, 
		FEE_DISPOSITION_ID, 
		CONTRACT_FEE_ID, 
		AUTHORIZED_FEE_ID, 
		SERVICE_RECEIVING_FEE_ID, 
		REASON_USING_FEE_ID, 
		FEE_COMMENTS, 
		REMOVED_DATE, 
		TYPE_OF_BED_WARD,
		REQUESTED_BED_UID,
		REQUESTED_BED_DATE,
		REQUESTED_DATE,
		VISTA_SITE_UID,
		IS_IN_HOUSE,
		LAST_EDIT_BY,
		IS_BED_IN_ISOLATION,
		WAIT_TIME_ALERT_DATE,
		IS_COMMUNITY_LIVING_CENTER,
		IS_EVACUATION_PATIENT,
		EVACUATION_DISPOSITION_STATUS_ID,
		EVACUATION_EXPECTED_DATE,
		EVACUATION_ACTUAL_DATE,
		EVACUATION_REASON_FOR_DELAY,
		EVACUATION_TRANSFER_EVACUATE_TO,
		EVACUATION_EQUIP_SUPPLY_REQUIREMENTS,
		EVACUATION_TRANSPORTATION_CARE_LEVEL,
		EVACUATION_ENROUTE_MEDICAL_ATTENDANT,
		EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT,
		EVACUATION_TRANSPORTATION_TYPE_ID,
		EVACUATION_TRANSPORTATION_PROVIDER_ID,
		EVACUATION_TRANSPORTATION_COMMENTS,
		EVACUATION_DESTINATION_ADDRESS,
		EVACUATION_DESTINATION_CITY_STATE,
		EVACUATION_DESTINATION_POC_TELEPHONE,
		EVACUATION_ORIGINATOR_POC_TELEPHONE,
		EVACUATION_COMMENTS,
		EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
		EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER
		)
		SELECT 
		ACT.DESTINATION_ID, 
		FACILITY.DESTINATION_ORGANIZATION_UID, 
		D_WAITING_AREA.ID, 
		WL.PROBLEM, 
		D_FEE_DISPOSITION.ID, 
		D_CONTRACT_FEE.ID, 
		D_AUTHORIZED_FEE.ID, 
		D_SERVICE_RECEIVING_FEE.ID, 
		D_REASON_USING_FEE.ID, 
		WL.FEE_COMMENTS, 
		WL.REMOVED_DATE, 
		WL.TYPE_OF_BED_WARD,
		WL.REQUESTED_BED_UID,
		WL.REQUESTED_BED_DATE,
		WL.REQUESTED_DATE,
		VISTA.DESTINATION_ORGANIZATION_UID,
		WL.IS_IN_HOUSE,
		WL.LAST_EDIT_BY,
		WL.IS_BED_IN_ISOLATION,
		WL.WAIT_TIME_ALERT_DATE,
		WL.IS_COMMUNITY_LIVING_CENTER,
		WL.IS_EVACUATION_PATIENT,
		D_EVACUATION_DISPOSITION_STATUS.ID,
		WL.EVACUATION_EXPECTED_DATE,
		WL.EVACUATION_ACTUAL_DATE,
		WL.EVACUATION_REASON_FOR_DELAY,
		WL.EVACUATION_TRANSFER_EVACUATE_TO,
		WL.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS,
		WL.EVACUATION_TRANSPORTATION_CARE_LEVEL,
		WL.EVACUATION_ENROUTE_MEDICAL_ATTENDANT,
		WL.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT,
		D_EVACUATION_TRANSPORTATION_TYPE.ID,
		D_EVACUATION_TRANSPORTATION_PROVIDER.ID,
		WL.EVACUATION_TRANSPORTATION_COMMENTS,
		WL.EVACUATION_DESTINATION_ADDRESS,
		WL.EVACUATION_DESTINATION_CITY_STATE,
		WL.EVACUATION_DESTINATION_POC_TELEPHONE,
		WL.EVACUATION_ORIGINATOR_POC_TELEPHONE,
		WL.EVACUATION_COMMENTS,
		WL.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
		WL.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER
		FROM $(varSOURCE_BMS).dbo.WAITING_LIST AS WL
		INNER JOIN #MERGE_IDS AS ACT ON WL.ACT_ID = ACT.SOURCE_ID
		INNER JOIN #ORGANIZATIONS AS VISTA ON WL.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON WL.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_WAITING_AREA ON WL.WAITING_AREA_ID = S_WAITING_AREA.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_WAITING_AREA  ON S_WAITING_AREA.CODE = D_WAITING_AREA.CODE AND S_WAITING_AREA.CODE_SYSTEM_NAME = D_WAITING_AREA.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_FEE_DISPOSITION ON WL.FEE_DISPOSITION_ID = S_FEE_DISPOSITION.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_FEE_DISPOSITION  ON S_FEE_DISPOSITION.CODE = D_FEE_DISPOSITION.CODE AND S_FEE_DISPOSITION.CODE_SYSTEM_NAME = D_FEE_DISPOSITION.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_CONTRACT_FEE ON WL.CONTRACT_FEE_ID = S_CONTRACT_FEE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_CONTRACT_FEE ON S_CONTRACT_FEE.CODE = D_CONTRACT_FEE.CODE AND S_CONTRACT_FEE.CODE_SYSTEM_NAME = D_CONTRACT_FEE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_AUTHORIZED_FEE ON WL.AUTHORIZED_FEE_ID = S_AUTHORIZED_FEE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_AUTHORIZED_FEE ON S_AUTHORIZED_FEE.CODE = D_AUTHORIZED_FEE.CODE AND S_AUTHORIZED_FEE.CODE_SYSTEM_NAME = D_AUTHORIZED_FEE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_SERVICE_RECEIVING_FEE ON WL.SERVICE_RECEIVING_FEE_ID = S_SERVICE_RECEIVING_FEE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_SERVICE_RECEIVING_FEE ON S_SERVICE_RECEIVING_FEE.CODE = D_SERVICE_RECEIVING_FEE.CODE AND S_SERVICE_RECEIVING_FEE.CODE_SYSTEM_NAME = D_SERVICE_RECEIVING_FEE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_REASON_USING_FEE ON WL.REASON_USING_FEE_ID = S_REASON_USING_FEE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_REASON_USING_FEE ON S_REASON_USING_FEE.CODE = D_REASON_USING_FEE.CODE AND S_REASON_USING_FEE.CODE_SYSTEM_NAME = D_REASON_USING_FEE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_EVACUATION_DISPOSITION_STATUS ON WL.EVACUATION_DISPOSITION_STATUS_ID = S_EVACUATION_DISPOSITION_STATUS.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_EVACUATION_DISPOSITION_STATUS ON S_EVACUATION_DISPOSITION_STATUS.CODE = D_EVACUATION_DISPOSITION_STATUS.CODE AND S_EVACUATION_DISPOSITION_STATUS.CODE_SYSTEM_NAME = D_EVACUATION_DISPOSITION_STATUS.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_EVACUATION_TRANSPORTATION_TYPE ON WL.EVACUATION_TRANSPORTATION_TYPE_ID = S_EVACUATION_TRANSPORTATION_TYPE.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_EVACUATION_TRANSPORTATION_TYPE ON S_EVACUATION_TRANSPORTATION_TYPE.CODE = D_EVACUATION_TRANSPORTATION_TYPE.CODE AND S_EVACUATION_TRANSPORTATION_TYPE.CODE_SYSTEM_NAME = D_EVACUATION_TRANSPORTATION_TYPE.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_EVACUATION_TRANSPORTATION_PROVIDER ON WL.EVACUATION_TRANSPORTATION_PROVIDER_ID = S_EVACUATION_TRANSPORTATION_PROVIDER.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_EVACUATION_TRANSPORTATION_PROVIDER ON S_EVACUATION_TRANSPORTATION_PROVIDER.CODE = D_EVACUATION_TRANSPORTATION_PROVIDER.CODE AND S_EVACUATION_TRANSPORTATION_PROVIDER.CODE_SYSTEM_NAME = D_EVACUATION_TRANSPORTATION_PROVIDER.CODE_SYSTEM_NAME
		
		-- *** INSERT ADT *** --
		--INSERT DISCHARGE INTENT
		SELECT 'INSERT INTO BMS DISCHARGE INTENT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)	
		INSERT INTO $(varDESTINATION_BMS).dbo.DISCHARGE_INT(DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID,
		HOSPITAL_LOCATION_UID, WARD_UID, [STATUS])
		SELECT D_INT.DOMAIN_ID, D_INT.PATIENT_UID, D_INT.DATE_ENTERED, D_INT.IS_ACTIVE, D_INT.APPOINTMENT_DATE, VISTA.DESTINATION_ORGANIZATION_UID,
		D_INT.HOSPITAL_LOCATION_UID, D_INT.WARD_UID, D_INT.[STATUS] 
		FROM $(varSOURCE_BMS).dbo.DISCHARGE_INT AS D_INT
		INNER JOIN #ORGANIZATIONS AS VISTA ON D_INT.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID

		--INSERT REQUEST
		--INSERT ADMISSION
		DELETE FROM #MERGE_IDS
		SELECT 'INSERT INTO BMS ADMISSION_REQ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ADMISSION_REQ (DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA_SITE_UID,
			 HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT) 
		SELECT DOMAIN_ID, IEN, PATIENT_UID, ORDERED_DATE, IS_ACTIVE, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, PROVIDER_UID, VISTA.DESTINATION_ORGANIZATION_UID,
			 HOSPITAL_LOCATION_UID, WARD_UID, ORDER_TEXT
		FROM $(varSOURCE_BMS).dbo.ADMISSION_REQ AS REQ
		INNER JOIN #ORGANIZATIONS AS VISTA ON REQ.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID,ORDER_TYPE)
		SELECT DESTINATION_TABLE.ID, SOURCE_TABLE.ID, 'ADM' 
		FROM $(varDESTINATION_BMS).dbo.ADMISSION_REQ AS DESTINATION_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON DESTINATION_TABLE.VISTA_SITE_UID = VISTA.DESTINATION_ORGANIZATION_UID 
		INNER JOIN $(varSOURCE_BMS).dbo.ADMISSION_REQ AS SOURCE_TABLE ON VISTA.SOURCE_ORGANIZATION_UID = SOURCE_TABLE.VISTA_SITE_UID
				AND DESTINATION_TABLE.IEN = SOURCE_TABLE.IEN AND DESTINATION_TABLE.ORDERED_DATE = SOURCE_TABLE.ORDERED_DATE 
				
		--INSERT ORDER FACILITY
		SELECT 'INSERT INTO BMS ORDER_FACILITY - ADMISION ORDER_TYPE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ORDER_FACILITY (ORDER_ID, FACILITY_UID, ORDER_TYPE)
		SELECT NEW_ORDER_ID.DESTINATION_ID, FACILITY.DESTINATION_ORGANIZATION_UID, ORDER_F.ORDER_TYPE
		FROM $(varSOURCE_BMS).dbo.ORDER_FACILITY AS ORDER_F
		INNER JOIN #ORGANIZATIONS AS FACILITY ON ORDER_F.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS NEW_ORDER_ID ON ORDER_F.ORDER_ID = NEW_ORDER_ID.SOURCE_ID
		WHERE ORDER_F.ORDER_TYPE ='ADM'
	
		--INSERT TRANSFER
		SELECT 'INSERT INTO BMS TRANSFER REQ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.MOVEMENT_REQ (DOMAIN_ID, PATIENT_UID, IEN, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID,
			 HOSPITAL_LOCATION_UID, ORDER_TEXT, WARD_UID, IS_ACTIVE, ORDERED_DATE) 
		SELECT DOMAIN_ID, PATIENT_UID, IEN, SIGNED_BY_UID, SIGNED_DATE, RELEASED_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA.DESTINATION_ORGANIZATION_UID,
			 HOSPITAL_LOCATION_UID, ORDER_TEXT, WARD_UID, IS_ACTIVE, ORDERED_DATE
		FROM $(varSOURCE_BMS).dbo.MOVEMENT_REQ AS REQ
		INNER JOIN #ORGANIZATIONS AS VISTA ON REQ.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		
		DELETE FROM #MERGE_IDS
		
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID,ORDER_TYPE)
		SELECT DESTINATION_TABLE.ID, SOURCE_TABLE.ID, 'TRA' 
		FROM $(varDESTINATION_BMS).dbo.MOVEMENT_REQ AS DESTINATION_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON DESTINATION_TABLE.VISTA_SITE_UID = VISTA.DESTINATION_ORGANIZATION_UID 
		INNER JOIN $(varSOURCE_BMS).dbo.MOVEMENT_REQ AS SOURCE_TABLE ON VISTA.SOURCE_ORGANIZATION_UID = SOURCE_TABLE.VISTA_SITE_UID
				AND DESTINATION_TABLE.IEN = SOURCE_TABLE.IEN AND DESTINATION_TABLE.ORDERED_DATE = SOURCE_TABLE.ORDERED_DATE
		
		--INSERT ORDER FACILITY
		SELECT 'INSERT INTO BMS ORDER_FACILITY - TRANSFER ORDER_TYPE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ORDER_FACILITY (ORDER_ID, FACILITY_UID, ORDER_TYPE)
		SELECT NEW_ORDER_ID.DESTINATION_ID, FACILITY.DESTINATION_ORGANIZATION_UID, ORDER_F.ORDER_TYPE
		FROM $(varSOURCE_BMS).dbo.ORDER_FACILITY AS ORDER_F
		INNER JOIN #ORGANIZATIONS AS FACILITY ON ORDER_F.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS NEW_ORDER_ID ON ORDER_F.ORDER_ID = NEW_ORDER_ID.SOURCE_ID
		WHERE ORDER_F.ORDER_TYPE ='TRA'
		
		--INSERT DISCHARGE
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.ORDERABLE_ITEM_ID
																	 FROM $(varSOURCE_BMS).dbo.DISCHARGE_REQ AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.ORDERABLE_ITEM_ID IS NOT NULL)	
																	 
		SELECT 'INSERT INTO BMS DISCHARGE_REQ' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.DISCHARGE_REQ (DOMAIN_ID, IEN, PATIENT_UID , ORDERED_DATE, IS_ACTIVE, RELEASED_DATE, SIGNED_DATE, SIGNED_BY_UID, SCHEDULER_UID, 
			 PROVIDER_UID, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, ORDER_TEXT, ORDERABLE_ITEM_ID, WARD_UID)
		SELECT DOMAIN_ID, IEN, PATIENT_UID , ORDERED_DATE, IS_ACTIVE, RELEASED_DATE, SIGNED_DATE, SIGNED_BY_UID, SCHEDULER_UID, 
			 PROVIDER_UID, VISTA.DESTINATION_ORGANIZATION_UID, HOSPITAL_LOCATION_UID, ORDER_TEXT, D_ORDERABLE_ITEM.ID, WARD_UID
		FROM $(varSOURCE_BMS).dbo.DISCHARGE_REQ AS S
		INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_ORDERABLE_ITEM ON S.ORDERABLE_ITEM_ID = S_ORDERABLE_ITEM.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_ORDERABLE_ITEM ON S_ORDERABLE_ITEM.CODE = D_ORDERABLE_ITEM.CODE AND S_ORDERABLE_ITEM.CODE_SYSTEM_NAME = D_ORDERABLE_ITEM.CODE_SYSTEM_NAME

		
		DELETE FROM #MERGE_IDS
		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID,ORDER_TYPE)
		SELECT DESTINATION_TABLE.ID, SOURCE_TABLE.ID, 'DIS' 
		FROM $(varDESTINATION_BMS).dbo.DISCHARGE_REQ AS DESTINATION_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON DESTINATION_TABLE.VISTA_SITE_UID = VISTA.DESTINATION_ORGANIZATION_UID 
		INNER JOIN $(varSOURCE_BMS).dbo.DISCHARGE_REQ AS SOURCE_TABLE ON VISTA.SOURCE_ORGANIZATION_UID = SOURCE_TABLE.VISTA_SITE_UID
				AND DESTINATION_TABLE.IEN = SOURCE_TABLE.IEN AND DESTINATION_TABLE.ORDERED_DATE = SOURCE_TABLE.ORDERED_DATE

		--INSERT ORDER FACILITY
		SELECT 'INSERT INTO BMS ORDER_FACILITY - DISCHARGE ORDER_TYPE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ORDER_FACILITY (ORDER_ID, FACILITY_UID, ORDER_TYPE)
		SELECT NEW_ORDER_ID.DESTINATION_ID, FACILITY.DESTINATION_ORGANIZATION_UID, ORDER_F.ORDER_TYPE
		FROM $(varSOURCE_BMS).dbo.ORDER_FACILITY AS ORDER_F
		INNER JOIN #ORGANIZATIONS AS FACILITY ON ORDER_F.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS NEW_ORDER_ID ON ORDER_F.ORDER_ID = NEW_ORDER_ID.SOURCE_ID
		WHERE ORDER_F.ORDER_TYPE ='DIS'

		--INSERT EVENT
		--INSERT ADMISSION	
		DELETE FROM #MERGE_IDS
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.TYPE_OF_MOVEMENT_ID
																	 FROM $(varSOURCE_BMS).dbo.ADMISSION_EVN AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.TYPE_OF_MOVEMENT_ID IS NOT NULL)	
		
		SELECT 'INSERT INTO BMS ADMISSION_EVN' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ADMISSION_EVN(DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID,
				 VISTA_SITE_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, HAS_DISCHARGE)
		SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, BED_UID, WARD_UID, INITIAL_BED_UID, INITIAL_WARD_UID,
				 VISTA.DESTINATION_ORGANIZATION_UID, ATND_NURSE_UID, ADMISSION_DATE, ENTERED_BY_UID, D_TYPE_OF_MOVEMENT.ID, HAS_DISCHARGE
		FROM  $(varSOURCE_BMS).dbo.ADMISSION_EVN AS S
		INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_TYPE_OF_MOVEMENT ON S.TYPE_OF_MOVEMENT_ID = S_TYPE_OF_MOVEMENT.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_TYPE_OF_MOVEMENT ON S_TYPE_OF_MOVEMENT.CODE = D_TYPE_OF_MOVEMENT.CODE AND S_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME = D_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME

		INSERT INTO #MERGE_IDS(DESTINATION_ID, SOURCE_ID)
		SELECT DESTINATION_TABLE.ID, SOURCE_TABLE.ID 
		FROM $(varDESTINATION_BMS).dbo.ADMISSION_EVN AS DESTINATION_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON DESTINATION_TABLE.VISTA_SITE_UID = VISTA.DESTINATION_ORGANIZATION_UID 
		INNER JOIN $(varSOURCE_BMS).dbo.ADMISSION_EVN AS SOURCE_TABLE ON DESTINATION_TABLE.IEN = SOURCE_TABLE.IEN AND VISTA.SOURCE_ORGANIZATION_UID = SOURCE_TABLE.VISTA_SITE_UID

		--INSERT TRANSEFR
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.TYPE_OF_MOVEMENT_ID
																	 FROM $(varSOURCE_BMS).dbo.MOVEMENT_EVN AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.TYPE_OF_MOVEMENT_ID IS NOT NULL)
		
		SELECT 'INSERT INTO BMS MOVEMENT_EVN' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT $(varDESTINATION_BMS).dbo.MOVEMENT_EVN (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, 
			 TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID)
		SELECT EVN.DOMAIN_ID, EVN.IEN, EVN.PATIENT_UID, EVN.ENTERED_DATE, EVN.WARD_UID, EVN.BED_UID, EVN.OLD_WARD_UID, EVN.OLD_BED_UID, 
			VISTA.DESTINATION_ORGANIZATION_UID, D_TYPE_OF_MOVEMENT.ID, EVN.MOVEMENT_DATE, EVN.ENTERED_BY_UID, ADMISSION.DESTINATION_ID
		FROM  $(varSOURCE_BMS).dbo.MOVEMENT_EVN AS EVN
		INNER JOIN #ORGANIZATIONS AS VISTA ON EVN.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS ADMISSION ON EVN.ADMISSION_ID = ADMISSION.SOURCE_ID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_TYPE_OF_MOVEMENT ON EVN.TYPE_OF_MOVEMENT_ID = S_TYPE_OF_MOVEMENT.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_TYPE_OF_MOVEMENT ON S_TYPE_OF_MOVEMENT.CODE = D_TYPE_OF_MOVEMENT.CODE AND S_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME = D_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME

		--INSERT BED SWITCH
		SELECT 'INSERT INTO BMS BED_SWITCH' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_SWITCH(ENTERED_DATE, DOMAIN_ID, IEN, PATIENT_UID, WARD_UID, BED_UID,
				OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID)
		SELECT BED.ENTERED_DATE, BED.DOMAIN_ID, BED.IEN, BED.PATIENT_UID, BED.WARD_UID, BED.BED_UID,
				BED.OLD_BED_UID, VISTA.DESTINATION_ORGANIZATION_UID, ADMISSION.DESTINATION_ID
		FROM  $(varSOURCE_BMS).dbo.BED_SWITCH AS BED
		INNER JOIN #ORGANIZATIONS AS VISTA ON BED.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS ADMISSION ON BED.ADMISSION_ID = ADMISSION.SOURCE_ID

		--INSERT ADMISSION_LEVEL_OF_CARE
		SELECT 'INSERT INTO BMS ADMISSION_LEVEL_OF_CARE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ADMISSION_LEVEL_OF_CARE(ADMISSION_ID, LEVEL_OF_CARE, CREATION_DATE)
		SELECT ADMISSION.DESTINATION_ID, A.LEVEL_OF_CARE, A.CREATION_DATE
		FROM  $(varSOURCE_BMS).dbo.ADMISSION_LEVEL_OF_CARE AS A
		INNER JOIN #MERGE_IDS AS ADMISSION ON A.ADMISSION_ID = ADMISSION.SOURCE_ID

		--INSERT SPECIALTY TRANSFER
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.TYPE_OF_MOVEMENT_ID
																	 FROM $(varSOURCE_BMS).dbo.SPECIALTY_TRANSFER AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.TYPE_OF_MOVEMENT_ID IS NOT NULL)
		
		SELECT 'INSERT INTO BMS SPECIALTY_TRANSFER' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.SPECIALTY_TRANSFER(IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, 
				ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID)
		SELECT SPECIALTY_TRANS.IEN, SPECIALTY_TRANS.PATIENT_UID, SPECIALTY_TRANS.DOMAIN_ID, VISTA.DESTINATION_ORGANIZATION_UID, SPECIALTY_TRANS.DATE_TIME, 
		  D_TYPE_OF_MOVEMENT.ID, SPECIALTY_TRANS.ENTERED_DATE, SPECIALTY_TRANS.ENTERED_BY_UID, ADMISSION.DESTINATION_ID
		FROM  $(varSOURCE_BMS).dbo.SPECIALTY_TRANSFER AS SPECIALTY_TRANS
		INNER JOIN #ORGANIZATIONS AS VISTA ON SPECIALTY_TRANS.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN #MERGE_IDS AS ADMISSION ON SPECIALTY_TRANS.ADMISSION_ID = ADMISSION.SOURCE_ID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_TYPE_OF_MOVEMENT ON SPECIALTY_TRANS.TYPE_OF_MOVEMENT_ID = S_TYPE_OF_MOVEMENT.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_TYPE_OF_MOVEMENT ON S_TYPE_OF_MOVEMENT.CODE = D_TYPE_OF_MOVEMENT.CODE AND S_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME = D_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME

		--INSERT SCHEDULED ADMISSION
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.SPECIALITY_ID
																	 FROM $(varSOURCE_BMS).dbo.SCHEDULED_ADMISSION AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.SPECIALITY_ID IS NOT NULL)
																	 
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.VISTA_DIVISION_ID
																	 FROM $(varSOURCE_BMS).dbo.SCHEDULED_ADMISSION AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.VISTA_DIVISION_ID IS NOT NULL)																	 
		
		SELECT 'INSERT INTO BMS SCHEDULED_ADMISSION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.SCHEDULED_ADMISSION(PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID,
		VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID)
		SELECT SA.PATIENT_UID, SA.IEN, SA.DOMAIN_ID, SA.CANCELED_DATE, SA.RESERVATION_DATE, SA.SCHEDULER_UID, SA.PROVIDER_UID,
		VISTA.DESTINATION_ORGANIZATION_UID, WARD_UID, D_SPECIALITY.ID, SA.DIAGNOSIS, SA.SURGERY, SA.LENGTH_OF_STAY_EXPECTED,
		D_VISTA_DIVISION.ID
		FROM  $(varSOURCE_BMS).dbo.SCHEDULED_ADMISSION AS SA
		INNER JOIN #ORGANIZATIONS AS VISTA ON SA.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_SPECIALITY ON SA.SPECIALITY_ID = S_SPECIALITY.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_SPECIALITY ON S_SPECIALITY.CODE = D_SPECIALITY.CODE AND S_SPECIALITY.CODE_SYSTEM_NAME = D_SPECIALITY.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_VISTA_DIVISION ON SA.VISTA_DIVISION_ID = S_VISTA_DIVISION.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_VISTA_DIVISION ON S_VISTA_DIVISION.CODE = D_VISTA_DIVISION.CODE AND S_VISTA_DIVISION.CODE_SYSTEM_NAME = D_VISTA_DIVISION.CODE_SYSTEM_NAME

		--INSERT DISCHARGE
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.TYPE_OF_MOVEMENT_ID
																	 FROM $(varSOURCE_BMS).dbo.DISCHARGE_EVN AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.TYPE_OF_MOVEMENT_ID IS NOT NULL)		
		
		SELECT 'INSERT INTO BMS DISCHARGE_EVN' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.DISCHARGE_EVN(DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, WARD_UID, BED_UID, 
		VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID)
		SELECT EVN.DOMAIN_ID, EVN.IEN, EVN.PATIENT_UID, EVN.ENTERED_DATE, EVN.WARD_UID, EVN.BED_UID, 
		VISTA.DESTINATION_ORGANIZATION_UID, EVN.DISCHARGED_DATE, EVN.ENTERED_BY_UID, D_TYPE_OF_MOVEMENT.ID, ADMISSION.DESTINATION_ID
		FROM  $(varSOURCE_BMS).dbo.DISCHARGE_EVN AS EVN
		INNER JOIN #ORGANIZATIONS AS VISTA ON EVN.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		INNER JOIN #MERGE_IDS AS ADMISSION ON EVN.ADMISSION_ID = ADMISSION.SOURCE_ID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_TYPE_OF_MOVEMENT ON EVN.TYPE_OF_MOVEMENT_ID = S_TYPE_OF_MOVEMENT.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_TYPE_OF_MOVEMENT ON S_TYPE_OF_MOVEMENT.CODE = D_TYPE_OF_MOVEMENT.CODE AND S_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME = D_TYPE_OF_MOVEMENT.CODE_SYSTEM_NAME

		DROP TABLE #MERGE_IDS

		-- *** INSERT IMAGES *** --
		SELECT 'INSERT INTO BMS ICON_ASSOCIATION' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.ICON_ASSOCIATION(BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID)
		SELECT BED_UID, PATIENT_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID
		FROM $(varSOURCE_BMS).dbo.ICON_ASSOCIATION
		WHERE ICON_FLAG_FACILITY_ID IS NULL
		
		--DROP DUPLICATE BED ASSOCIATION
		;WITH CTE (BED_UID, ICON_FLAG_ID, DuplicateCount)
		AS
		(
		SELECT BED_UID, ICON_FLAG_ID,
		ROW_NUMBER() OVER(PARTITION BY BED_UID, ICON_FLAG_ID ORDER BY BED_UID) AS DuplicateCount
		FROM $(varDESTINATION_BMS).dbo.ICON_ASSOCIATION
		WHERE BED_UID IS NOT NULL
		)
		DELETE
		FROM CTE
		WHERE DuplicateCount > 1
		
		--DROP DUPLICATE PATIENT ASSOCIATION
		;WITH CTE (PATIENT_UID, ICON_FLAG_ID, DuplicateCount)
		AS
		(
		SELECT PATIENT_UID, ICON_FLAG_ID,
		ROW_NUMBER() OVER(PARTITION BY PATIENT_UID, ICON_FLAG_ID ORDER BY PATIENT_UID) AS DuplicateCount
		FROM $(varDESTINATION_BMS).dbo.ICON_ASSOCIATION
		WHERE PATIENT_UID IS NOT NULL
		)
		DELETE
		FROM CTE
		WHERE DuplicateCount > 1
		
		-- *** INSERT BED CLEAN *** --
		
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.TYPE_OF_CLEAN_ID
																	 FROM $(varSOURCE_BMS).dbo.BED_CLEAN AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.TYPE_OF_CLEAN_ID IS NOT NULL)
																	 
		INSERT INTO $(varDESTINATION_BMS).dbo.CONCEPT(CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME)
		SELECT SOURCE_TABLE.CODE, SOURCE_TABLE.CODE_SYSTEM, SOURCE_TABLE.CODE_SYSTEM_NAME, SOURCE_TABLE.DISPLAY_NAME 
		FROM  $(varSOURCE_BMS).dbo.CONCEPT AS SOURCE_TABLE
		LEFT OUTER JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS DESTINATION_TABLE ON SOURCE_TABLE.CODE = DESTINATION_TABLE.CODE AND SOURCE_TABLE.CODE_SYSTEM_NAME = DESTINATION_TABLE.CODE_SYSTEM_NAME
		WHERE DESTINATION_TABLE.CODE IS NULL AND SOURCE_TABLE.ID IN (SELECT DISTINCT S.MANUAL_REQUEST_ID
																	 FROM $(varSOURCE_BMS).dbo.BED_CLEAN AS S
																	 INNER JOIN #ORGANIZATIONS AS VISTA ON S.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
																	 WHERE S.MANUAL_REQUEST_ID IS NOT NULL)																	 
		
		SELECT 'INSERT INTO BMS BED_CLEAN' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.BED_CLEAN
		(  BED_UID, WARD_UID, TYPE_OF_CLEAN_ID, MANUAL_REQUEST_ID, ACCEPTED_DATE, ACCEPTED_BY, COMPLETED_DATE, COMPLETED_BY,
		LAST_EDITED_BY, LAST_EDIT_DATE, REQUESTED_DATE, VISTA_SITE_UID, DIVISION_UID, EMS_NOTIFY, SPECIAL_INSTRUCTIONS,
		VACATED_DATE, EVENT_TYPE, DOMAIN_ID, EVENT_IEN)
		SELECT BC.BED_UID, BC.WARD_UID, D_TYPE_OF_CLEAN.ID, D_MANUAL_REQUEST.ID, BC.ACCEPTED_DATE, 
		BC.ACCEPTED_BY, BC.COMPLETED_DATE, BC.COMPLETED_BY, BC.LAST_EDITED_BY, BC.LAST_EDIT_DATE, BC.REQUESTED_DATE, 
		VISTA.DESTINATION_ORGANIZATION_UID, BC.DIVISION_UID, BC.EMS_NOTIFY, BC.SPECIAL_INSTRUCTIONS,
		BC.VACATED_DATE, BC.EVENT_TYPE, BC.DOMAIN_ID, BC.EVENT_IEN 
		FROM $(varSOURCE_BMS).dbo.BED_CLEAN AS BC
		INNER JOIN #ORGANIZATIONS AS VISTA ON BC.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_TYPE_OF_CLEAN ON BC.TYPE_OF_CLEAN_ID = S_TYPE_OF_CLEAN.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_TYPE_OF_CLEAN ON S_TYPE_OF_CLEAN.CODE = D_TYPE_OF_CLEAN.CODE AND S_TYPE_OF_CLEAN.CODE_SYSTEM_NAME = D_TYPE_OF_CLEAN.CODE_SYSTEM_NAME
		LEFT JOIN $(varSOURCE_BMS).dbo.CONCEPT AS S_MANUAL_REQUEST ON BC.MANUAL_REQUEST_ID = S_MANUAL_REQUEST.ID
		LEFT JOIN $(varDESTINATION_BMS).dbo.CONCEPT AS D_MANUAL_REQUEST ON S_MANUAL_REQUEST.CODE = D_MANUAL_REQUEST.CODE AND S_MANUAL_REQUEST.CODE_SYSTEM_NAME = D_MANUAL_REQUEST.CODE_SYSTEM_NAME
		
		--INSERT INTO BMS DATABASE (VISTA_OPERATION TABLE)
		SELECT 'INSERT INTO BMS VISTA_OPERATIONS' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.VISTA_OPERATIONS(VISTA_ID, OPERATION_ID, LAST_RUNNING)
		SELECT VISTA.DESTINATION_ORGANIZATION_UID, SOURCE_TABLE.OPERATION_ID, SOURCE_TABLE.LAST_RUNNING
		FROM $(varSOURCE_BMS).dbo.VISTA_OPERATIONS AS SOURCE_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON SOURCE_TABLE.VISTA_ID = VISTA.SOURCE_ORGANIZATION_UID
		
		--INSERT INTO BMS DATABASE (VISTA_INTEGRATION_LOG TABLE)
		SELECT 'INSERT INTO BMS VISTA_INTEGRATION_LOG' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.VISTA_INTEGRATION_LOG(IEN, VISTA, VISTA_FILE)
		SELECT IEN, VISTA, VISTA_FILE
		FROM $(varSOURCE_BMS).dbo.VISTA_INTEGRATION_LOG AS VIL
		INNER JOIN @IMPORT_VISTA AS VISTA ON VIL.VISTA = VISTA.CODE

		--INSERT INTO BMS DATABASE (JOB_AUDIT)
		SELECT 'INSERT INTO BMS JOB_AUDIT' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS).dbo.JOB_AUDIT(VISTA_NAME, VISTA_ID, RETRIEVAL_METHOD, RETRIEVED_DATA_TYPE, RETRIEVED_ENTRIES_NUMBER,
					START_DATE, END_DATE, LAUNCH_TYPE, STATUS, ERROR_MESSAGE, DETAILS)
		SELECT VISTA_NAME, VISTA.DESTINATION_ORGANIZATION_UID, RETRIEVAL_METHOD, RETRIEVED_DATA_TYPE, RETRIEVED_ENTRIES_NUMBER, START_DATE, END_DATE, LAUNCH_TYPE, STATUS, ERROR_MESSAGE, DETAILS
		FROM $(varSOURCE_BMS).dbo.JOB_AUDIT AS SOURCE_TABLE
		INNER JOIN #ORGANIZATIONS AS VISTA ON SOURCE_TABLE.VISTA_ID = VISTA.SOURCE_ORGANIZATION_UID
		
		SELECT 'INSERT INTO BMS JOB_AUDIT_PARAM' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		;WITH CTE_JOB_AUDIT (DESTINATION_ID, SOURCE_ID)
		AS
		(
			SELECT DESTINATION_TABLE.ID, SOURCE_TABLE.ID
			FROM $(varSOURCE_BMS).dbo.JOB_AUDIT AS SOURCE_TABLE
			INNER JOIN #ORGANIZATIONS AS VISTA ON SOURCE_TABLE.VISTA_ID = VISTA.SOURCE_ORGANIZATION_UID
			INNER JOIN $(varDESTINATION_BMS).dbo.JOB_AUDIT AS DESTINATION_TABLE ON VISTA.DESTINATION_ORGANIZATION_UID = DESTINATION_TABLE.VISTA_ID
											AND SOURCE_TABLE.RETRIEVED_DATA_TYPE = DESTINATION_TABLE.RETRIEVED_DATA_TYPE
											AND SOURCE_TABLE.START_DATE = DESTINATION_TABLE.START_DATE
		)
		
		--INSERT INTO JOB_AUDIT_PARAM
		INSERT INTO $(varDESTINATION_BMS).dbo.JOB_AUDIT_PARAM(JOB_AUDIT_ID, NAME, VALUE)
		SELECT JOB_AUDIT.DESTINATION_ID, SOURCE_TABLE.NAME, SOURCE_TABLE.VALUE
		FROM $(varSOURCE_BMS).dbo.JOB_AUDIT_PARAM AS SOURCE_TABLE
		INNER JOIN CTE_JOB_AUDIT AS JOB_AUDIT ON SOURCE_TABLE.JOB_AUDIT_ID = JOB_AUDIT.SOURCE_ID
		
		SELECT 'END IMPORT BMS DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
			
		-- *** INSERT INTO BMS *** --
		SELECT 'START IMPORT BMS_InstanceStore DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		CREATE TABLE #SURROGATE_INSTANCE(DESTINATION_SurrogateInstanceId BIGINT, SOURCE_SurrogateInstanceId BIGINT)

		SELECT 'IMPORT INTO BMS_InstanceStore - InstancesTable' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		DECLARE @CTX_ACT TABLE (FLOW_ID UNIQUEIDENTIFIER)
		INSERT INTO @CTX_ACT(FLOW_ID)
		SELECT FLOW_ID
		FROM $(varSOURCE_BMS).dbo.ACT AS A 
		INNER JOIN $(varSOURCE_BMS).dbo.BED_UNAVAILABLE AS BU ON BU.ACT_ID = A.ID
		INNER JOIN #ORGANIZATIONS AS VISTA ON BU.VISTA_SITE_UID = VISTA.SOURCE_ORGANIZATION_UID
		UNION
		SELECT FLOW_ID
		FROM $(varSOURCE_BMS).dbo.ACT AS A 
		INNER JOIN $(varSOURCE_BMS).dbo.WAITING_LIST AS WL ON WL.ACT_ID = A.ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON WL.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
		UNION
		SELECT FLOW_ID
		FROM $(varSOURCE_BMS).dbo.ACT AS A 
		INNER JOIN $(varSOURCE_BMS).dbo.TRANSFER_REQ AS TR ON TR.ACT_ID = A.ID
		INNER JOIN #ORGANIZATIONS AS FACILITY ON TR.FACILITY_UID = FACILITY.SOURCE_ORGANIZATION_UID
			
		;MERGE $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstancesTable] AS DESTINATION_TABLE
		USING (SELECT DISTINCT IT.*
			   FROM $(varSOURCE_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstancesTable] AS IT
			   INNER JOIN @CTX_ACT AS ACT ON ACT.FLOW_ID = IT.Id ) SOURCE_TABLE	
		ON 0 = 1
		WHEN NOT MATCHED THEN
		INSERT ([Id], [SurrogateLockOwnerId], [PrimitiveDataProperties], [ComplexDataProperties], [WriteOnlyPrimitiveDataProperties],
			[WriteOnlyComplexDataProperties], [MetadataProperties], [DataEncodingOption], [MetadataEncodingOption], [Version],
			[PendingTimer], [CreationTime], [LastUpdated], [WorkflowHostType], [ServiceDeploymentId], [SuspensionExceptionName],
			[SuspensionReason], [BlockingBookmarks], [LastMachineRunOn], [ExecutionStatus], [IsInitialized], [IsSuspended],
			[IsReadyToRun], [IsCompleted])
		VALUES([Id], [SurrogateLockOwnerId], [PrimitiveDataProperties], [ComplexDataProperties], [WriteOnlyPrimitiveDataProperties],
			[WriteOnlyComplexDataProperties], [MetadataProperties], [DataEncodingOption], [MetadataEncodingOption], [Version],
			[PendingTimer], [CreationTime], [LastUpdated], [WorkflowHostType], [ServiceDeploymentId], [SuspensionExceptionName],
			[SuspensionReason], [BlockingBookmarks], [LastMachineRunOn], [ExecutionStatus], [IsInitialized], [IsSuspended],
			[IsReadyToRun], [IsCompleted])
		OUTPUT
		INSERTED.SurrogateInstanceId, SOURCE_TABLE.SurrogateInstanceId INTO #SURROGATE_INSTANCE(DESTINATION_SurrogateInstanceId, SOURCE_SurrogateInstanceId);

	    SELECT 'IMPORT INTO BMS_InstanceStore - [RunnableInstancesTable]' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[RunnableInstancesTable]
		([SurrogateInstanceId], [WorkflowHostType], [ServiceDeploymentId], [RunnableTime])
		SELECT SI.DESTINATION_SurrogateInstanceId, RIT.WorkflowHostType, RIT.ServiceDeploymentId, RIT.RunnableTime
		FROM $(varSOURCE_BMS_InstanceStore).[System.Activities.DurableInstancing].[RunnableInstancesTable] AS RIT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON RIT.SurrogateInstanceId = SI.SOURCE_SurrogateInstanceId
		
		SET IDENTITY_INSERT $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] ON
		
		SELECT 'IMPORT INTO BMS_InstanceStore - [InstanceMetadataChangesTable]' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstanceMetadataChangesTable]
		([SurrogateInstanceId], [ChangeTime], [EncodingOption], [Change])
		SELECT SI.DESTINATION_SurrogateInstanceId, IMCT.ChangeTime, IMCT.EncodingOption, IMCT.Change
		FROM $(varSOURCE_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] AS IMCT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON IMCT.SurrogateInstanceId = SI.SOURCE_SurrogateInstanceId
		
		SET IDENTITY_INSERT $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstanceMetadataChangesTable] OFF
		
		SELECT 'IMPORT INTO BMS_InstanceStore - [KeysTable]' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[KeysTable]
		([Id], [SurrogateInstanceId], [EncodingOption], [Properties], [IsAssociated])
		SELECT KT.Id ,SI.DESTINATION_SurrogateInstanceId, KT.EncodingOption, KT.Properties, KT.IsAssociated
		FROM $(varSOURCE_BMS_InstanceStore).[System.Activities.DurableInstancing].[KeysTable] AS KT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON KT.SurrogateInstanceId = SI.SOURCE_SurrogateInstanceId

		SELECT 'IMPORT INTO BMS_InstanceStore - [InstancePromotedPropertiesTable]' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		INSERT INTO $(varDESTINATION_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstancePromotedPropertiesTable]
		([SurrogateInstanceId], [PromotionName], [Value1], [Value2], [Value3], [Value4], [Value5], [Value6], [Value7], [Value8], [Value9],
		[Value10], [Value11], [Value12], [Value13], [Value14], [Value15], [Value16], [Value17], [Value18], [Value19], [Value20], [Value21],
		[Value22], [Value23], [Value24], [Value25], [Value26], [Value27], [Value28], [Value29], [Value30], [Value31], [Value32], [Value33] ,
		[Value34], [Value35], [Value36], [Value37], [Value38], [Value39], [Value40], [Value41], [Value42], [Value43], [Value44], [Value45],
		[Value46], [Value47], [Value48], [Value49], [Value50], [Value51], [Value52], [Value53], [Value54], [Value55], [Value56], [Value57],
		[Value58], [Value59], [Value60], [Value61], [Value62], [Value63], [Value64])
		SELECT SI.DESTINATION_SurrogateInstanceId, [PromotionName], [Value1], [Value2], [Value3], [Value4], [Value5], [Value6], [Value7], [Value8], [Value9],
		[Value10], [Value11], [Value12], [Value13], [Value14], [Value15], [Value16], [Value17], [Value18], [Value19], [Value20], [Value21],
		[Value22], [Value23], [Value24], [Value25], [Value26], [Value27], [Value28], [Value29], [Value30], [Value31], [Value32], [Value33] ,
		[Value34], [Value35], [Value36], [Value37], [Value38], [Value39], [Value40], [Value41], [Value42], [Value43], [Value44], [Value45],
		[Value46], [Value47], [Value48], [Value49], [Value50], [Value51], [Value52], [Value53], [Value54], [Value55], [Value56], [Value57],
		[Value58], [Value59], [Value60], [Value61], [Value62], [Value63], [Value64]
		FROM $(varSOURCE_BMS_InstanceStore).[System.Activities.DurableInstancing].[InstancePromotedPropertiesTable] AS IPPT
		INNER JOIN #SURROGATE_INSTANCE AS SI ON IPPT.SurrogateInstanceId = SI.SOURCE_SurrogateInstanceId
		
		SELECT 'END IMPORT BMS_InstanceStore DATABASE' + ' ' + CONVERT(NVARCHAR(100), GETDATE(), 108)
		
		DROP TABLE #SURROGATE_INSTANCE
		DROP TABLE #ORGANIZATIONS
		
		USE $(varSOURCE_BMS_EIS)
		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_Get_Patient_Ien_List]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
			DROP FUNCTION [dbo].[fn_Get_Patient_Ien_List]
		
		IF TYPE_ID(N'IMPORT_VISTA_CODE_TYPE') IS NOT NULL
			DROP TYPE IMPORT_VISTA_CODE_TYPE
	
	SELECT 'BMS DATABASES - successfully imported'
	

	--ROLLBACK TRANSACTION;
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	SELECT ERROR_LINE() AS ErrorLine,
			ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
SET QUOTED_IDENTIFIER ON
